/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.notes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateContactNoteRequest {
    private final String contactId;
    private final String body;
    private final Optional<String> adminId;
    private final Map<String, Object> additionalProperties;

    private CreateContactNoteRequest(String contactId, String body, Optional<String> adminId, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.body = body;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="admin_id")
    public Optional<String> getAdminId() {
        return this.adminId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateContactNoteRequest && this.equalTo((CreateContactNoteRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateContactNoteRequest other) {
        return this.contactId.equals(other.contactId) && this.body.equals(other.body) && this.adminId.equals(other.adminId);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.body, this.adminId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContactIdStage,
    BodyStage,
    _FinalStage {
        private String contactId;
        private String body;
        private Optional<String> adminId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateContactNoteRequest other) {
            this.contactId(other.getContactId());
            this.body(other.getBody());
            this.adminId(other.getAdminId());
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public BodyStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public _FinalStage adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        @Override
        @JsonSetter(value="admin_id", nulls=Nulls.SKIP)
        public _FinalStage adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        @Override
        public CreateContactNoteRequest build() {
            return new CreateContactNoteRequest(this.contactId, this.body, this.adminId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateContactNoteRequest build();

        public _FinalStage adminId(Optional<String> var1);

        public _FinalStage adminId(String var1);
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull String var1);
    }

    public static interface ContactIdStage {
        public BodyStage contactId(@NotNull String var1);

        public Builder from(CreateContactNoteRequest var1);
    }
}

