/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.segments.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Segment {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<PersonType> personType;
    private final Optional<Integer> count;
    private final Map<String, Object> additionalProperties;

    private Segment(Optional<String> type, Optional<String> id, Optional<String> name, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<PersonType> personType, Optional<Integer> count, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.personType = personType;
        this.count = count;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="person_type")
    public Optional<PersonType> getPersonType() {
        return this.personType;
    }

    @JsonProperty(value="count")
    public Optional<Integer> getCount() {
        return this.count;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Segment && this.equalTo((Segment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Segment other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.personType.equals(other.personType) && this.count.equals(other.count);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.createdAt, this.updatedAt, this.personType, this.count);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class PersonType {
        public static final PersonType USER = new PersonType(Value.USER, "user");
        public static final PersonType CONTACT = new PersonType(Value.CONTACT, "contact");
        private final Value value;
        private final String string;

        PersonType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof PersonType && this.string.equals(((PersonType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case USER: {
                    return visitor.visitUser();
                }
                case CONTACT: {
                    return visitor.visitContact();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static PersonType valueOf(String value) {
            switch (value) {
                case "user": {
                    return USER;
                }
                case "contact": {
                    return CONTACT;
                }
            }
            return new PersonType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitContact();

            public T visitUser();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CONTACT,
            USER,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<PersonType> personType = Optional.empty();
        private Optional<Integer> count = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Segment other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.personType(other.getPersonType());
            this.count(other.getCount());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="person_type", nulls=Nulls.SKIP)
        public Builder personType(Optional<PersonType> personType) {
            this.personType = personType;
            return this;
        }

        public Builder personType(PersonType personType) {
            this.personType = Optional.ofNullable(personType);
            return this;
        }

        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public Builder count(Optional<Integer> count) {
            this.count = count;
            return this;
        }

        public Builder count(Integer count) {
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Segment build() {
            return new Segment(this.type, this.id, this.name, this.createdAt, this.updatedAt, this.personType, this.count, this.additionalProperties);
        }
    }
}

