/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tags;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.tags.AsyncRawTagsClient;
import com.intercom.api.resources.tags.requests.DeleteTagRequest;
import com.intercom.api.resources.tags.requests.FindTagRequest;
import com.intercom.api.resources.tags.requests.TagContactRequest;
import com.intercom.api.resources.tags.requests.TagConversationRequest;
import com.intercom.api.resources.tags.requests.TagTicketRequest;
import com.intercom.api.resources.tags.requests.UntagContactRequest;
import com.intercom.api.resources.tags.requests.UntagConversationRequest;
import com.intercom.api.resources.tags.requests.UntagTicketRequest;
import com.intercom.api.resources.tags.types.Tag;
import com.intercom.api.resources.tags.types.TagsCreateRequestBody;
import com.intercom.api.types.TagList;
import java.util.concurrent.CompletableFuture;

public class AsyncTagsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTagsClient rawClient;

    public AsyncTagsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTagsClient(clientOptions);
    }

    public AsyncRawTagsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Tag> tagContact(TagContactRequest request) {
        return this.rawClient.tagContact(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> tagContact(TagContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagContact(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> untagContact(UntagContactRequest request) {
        return this.rawClient.untagContact(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> untagContact(UntagContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagContact(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> tagConversation(TagConversationRequest request) {
        return this.rawClient.tagConversation(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> tagConversation(TagConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagConversation(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> untagConversation(UntagConversationRequest request) {
        return this.rawClient.untagConversation(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> untagConversation(UntagConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagConversation(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<TagList> list() {
        return this.rawClient.list().thenApply(response -> (TagList)response.body());
    }

    public CompletableFuture<TagList> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (TagList)response.body());
    }

    public CompletableFuture<Tag> create(TagsCreateRequestBody request) {
        return this.rawClient.create(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> create(TagsCreateRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> find(FindTagRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> find(FindTagRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Void> delete(DeleteTagRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> delete(DeleteTagRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Tag> tagTicket(TagTicketRequest request) {
        return this.rawClient.tagTicket(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> tagTicket(TagTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagTicket(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> untagTicket(UntagTicketRequest request) {
        return this.rawClient.untagTicket(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> untagTicket(UntagTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagTicket(request, requestOptions).thenApply(response -> (Tag)response.body());
    }
}

