/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tags.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TagContactRequest {
    private final String contactId;
    private final String tagId;
    private final Map<String, Object> additionalProperties;

    private TagContactRequest(String contactId, String tagId, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.tagId = tagId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="id")
    public String getTagId() {
        return this.tagId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TagContactRequest && this.equalTo((TagContactRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TagContactRequest other) {
        return this.contactId.equals(other.contactId) && this.tagId.equals(other.tagId);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.tagId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContactIdStage,
    TagIdStage,
    _FinalStage {
        private String contactId;
        private String tagId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TagContactRequest other) {
            this.contactId(other.getContactId());
            this.tagId(other.getTagId());
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public TagIdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage tagId(@NotNull String tagId) {
            this.tagId = Objects.requireNonNull(tagId, "tagId must not be null");
            return this;
        }

        @Override
        public TagContactRequest build() {
            return new TagContactRequest(this.contactId, this.tagId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TagContactRequest build();
    }

    public static interface TagIdStage {
        public _FinalStage tagId(@NotNull String var1);
    }

    public static interface ContactIdStage {
        public TagIdStage contactId(@NotNull String var1);

        public Builder from(TagContactRequest var1);
    }
}

