/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.teams;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.teams.AsyncRawTeamsClient;
import com.intercom.api.resources.teams.requests.FindTeamRequest;
import com.intercom.api.resources.teams.types.Team;
import com.intercom.api.types.TeamList;
import java.util.concurrent.CompletableFuture;

public class AsyncTeamsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTeamsClient rawClient;

    public AsyncTeamsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTeamsClient(clientOptions);
    }

    public AsyncRawTeamsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TeamList> list() {
        return this.rawClient.list().thenApply(response -> (TeamList)response.body());
    }

    public CompletableFuture<TeamList> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (TeamList)response.body());
    }

    public CompletableFuture<Team> find(FindTeamRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Team)response.body());
    }

    public CompletableFuture<Team> find(FindTeamRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Team)response.body());
    }
}

