/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.jobs.types.Jobs;
import com.intercom.api.resources.tickets.RawTicketsClient;
import com.intercom.api.resources.tickets.requests.CreateTicketRequest;
import com.intercom.api.resources.tickets.requests.DeleteTicketRequest;
import com.intercom.api.resources.tickets.requests.EnqueueCreateTicketRequest;
import com.intercom.api.resources.tickets.requests.FindTicketRequest;
import com.intercom.api.resources.tickets.requests.ReplyToTicketRequest;
import com.intercom.api.resources.tickets.requests.UpdateTicketRequest;
import com.intercom.api.resources.tickets.types.DeleteTicketResponse;
import com.intercom.api.resources.tickets.types.Ticket;
import com.intercom.api.types.SearchRequest;
import com.intercom.api.types.TicketReply;
import java.util.Optional;

public class TicketsClient {
    protected final ClientOptions clientOptions;
    private final RawTicketsClient rawClient;

    public TicketsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTicketsClient(clientOptions);
    }

    public RawTicketsClient withRawResponse() {
        return this.rawClient;
    }

    public TicketReply reply(ReplyToTicketRequest request) {
        return this.rawClient.reply(request).body();
    }

    public TicketReply reply(ReplyToTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.reply(request, requestOptions).body();
    }

    public Optional<Ticket> create(CreateTicketRequest request) {
        return this.rawClient.create(request).body();
    }

    public Optional<Ticket> create(CreateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public Jobs enqueueCreateTicket(EnqueueCreateTicketRequest request) {
        return this.rawClient.enqueueCreateTicket(request).body();
    }

    public Jobs enqueueCreateTicket(EnqueueCreateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.enqueueCreateTicket(request, requestOptions).body();
    }

    public Optional<Ticket> get(FindTicketRequest request) {
        return this.rawClient.get(request).body();
    }

    public Optional<Ticket> get(FindTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public Optional<Ticket> update(UpdateTicketRequest request) {
        return this.rawClient.update(request).body();
    }

    public Optional<Ticket> update(UpdateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public DeleteTicketResponse deleteTicket(DeleteTicketRequest request) {
        return this.rawClient.deleteTicket(request).body();
    }

    public DeleteTicketResponse deleteTicket(DeleteTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteTicket(request, requestOptions).body();
    }

    public SyncPagingIterable<Optional<Ticket>> search(SearchRequest request) {
        return this.rawClient.search(request).body();
    }

    public SyncPagingIterable<Optional<Ticket>> search(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }
}

