/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tickets.types.TicketsReplyRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ReplyToTicketRequest {
    private final String ticketId;
    private final TicketsReplyRequestBody body;
    private final Map<String, Object> additionalProperties;

    private ReplyToTicketRequest(String ticketId, TicketsReplyRequestBody body, Map<String, Object> additionalProperties) {
        this.ticketId = ticketId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ticket_id")
    public String getTicketId() {
        return this.ticketId;
    }

    @JsonProperty(value="body")
    public TicketsReplyRequestBody getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ReplyToTicketRequest && this.equalTo((ReplyToTicketRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ReplyToTicketRequest other) {
        return this.ticketId.equals(other.ticketId) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.ticketId, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TicketIdStage,
    BodyStage,
    _FinalStage {
        private String ticketId;
        private TicketsReplyRequestBody body;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ReplyToTicketRequest other) {
            this.ticketId(other.getTicketId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="ticket_id")
        public BodyStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull TicketsReplyRequestBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public ReplyToTicketRequest build() {
            return new ReplyToTicketRequest(this.ticketId, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ReplyToTicketRequest build();
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull TicketsReplyRequestBody var1);
    }

    public static interface TicketIdStage {
        public BodyStage ticketId(@NotNull String var1);

        public Builder from(ReplyToTicketRequest var1);
    }
}

