/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tickets.types.TicketType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketStateDetailed {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<Category> category;
    private final Optional<String> internalLabel;
    private final Optional<String> externalLabel;
    private final Optional<Boolean> archived;
    private final Optional<TicketTypes> ticketTypes;
    private final Map<String, Object> additionalProperties;

    private TicketStateDetailed(Optional<String> type, Optional<String> id, Optional<Category> category, Optional<String> internalLabel, Optional<String> externalLabel, Optional<Boolean> archived, Optional<TicketTypes> ticketTypes, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.category = category;
        this.internalLabel = internalLabel;
        this.externalLabel = externalLabel;
        this.archived = archived;
        this.ticketTypes = ticketTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="category")
    public Optional<Category> getCategory() {
        return this.category;
    }

    @JsonProperty(value="internal_label")
    public Optional<String> getInternalLabel() {
        return this.internalLabel;
    }

    @JsonProperty(value="external_label")
    public Optional<String> getExternalLabel() {
        return this.externalLabel;
    }

    @JsonProperty(value="archived")
    public Optional<Boolean> getArchived() {
        return this.archived;
    }

    @JsonProperty(value="ticket_types")
    public Optional<TicketTypes> getTicketTypes() {
        return this.ticketTypes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketStateDetailed && this.equalTo((TicketStateDetailed)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketStateDetailed other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.category.equals(other.category) && this.internalLabel.equals(other.internalLabel) && this.externalLabel.equals(other.externalLabel) && this.archived.equals(other.archived) && this.ticketTypes.equals(other.ticketTypes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.category, this.internalLabel, this.externalLabel, this.archived, this.ticketTypes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Category {
        public static final Category IN_PROGRESS = new Category(Value.IN_PROGRESS, "in_progress");
        public static final Category SUBMITTED = new Category(Value.SUBMITTED, "submitted");
        public static final Category RESOLVED = new Category(Value.RESOLVED, "resolved");
        public static final Category WAITING_ON_CUSTOMER = new Category(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");
        private final Value value;
        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Category && this.string.equals(((Category)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case IN_PROGRESS: {
                    return visitor.visitInProgress();
                }
                case SUBMITTED: {
                    return visitor.visitSubmitted();
                }
                case RESOLVED: {
                    return visitor.visitResolved();
                }
                case WAITING_ON_CUSTOMER: {
                    return visitor.visitWaitingOnCustomer();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "in_progress": {
                    return IN_PROGRESS;
                }
                case "submitted": {
                    return SUBMITTED;
                }
                case "resolved": {
                    return RESOLVED;
                }
                case "waiting_on_customer": {
                    return WAITING_ON_CUSTOMER;
                }
            }
            return new Category(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitSubmitted();

            public T visitInProgress();

            public T visitWaitingOnCustomer();

            public T visitResolved();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            SUBMITTED,
            IN_PROGRESS,
            WAITING_ON_CUSTOMER,
            RESOLVED,
            UNKNOWN;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class TicketTypes {
        private final Optional<String> type;
        private final Optional<List<Optional<TicketType>>> data;
        private final Map<String, Object> additionalProperties;

        private TicketTypes(Optional<String> type, Optional<List<Optional<TicketType>>> data, Map<String, Object> additionalProperties) {
            this.type = type;
            this.data = data;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="data")
        public Optional<List<Optional<TicketType>>> getData() {
            return this.data;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TicketTypes && this.equalTo((TicketTypes)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(TicketTypes other) {
            return this.type.equals(other.type) && this.data.equals(other.data);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.data);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<Optional<TicketType>>> data = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(TicketTypes other) {
                this.type(other.getType());
                this.data(other.getData());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="data", nulls=Nulls.SKIP)
            public Builder data(Optional<List<Optional<TicketType>>> data) {
                this.data = data;
                return this;
            }

            public Builder data(List<Optional<TicketType>> data) {
                this.data = Optional.ofNullable(data);
                return this;
            }

            public TicketTypes build() {
                return new TicketTypes(this.type, this.data, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<Category> category = Optional.empty();
        private Optional<String> internalLabel = Optional.empty();
        private Optional<String> externalLabel = Optional.empty();
        private Optional<Boolean> archived = Optional.empty();
        private Optional<TicketTypes> ticketTypes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TicketStateDetailed other) {
            this.type(other.getType());
            this.id(other.getId());
            this.category(other.getCategory());
            this.internalLabel(other.getInternalLabel());
            this.externalLabel(other.getExternalLabel());
            this.archived(other.getArchived());
            this.ticketTypes(other.getTicketTypes());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="category", nulls=Nulls.SKIP)
        public Builder category(Optional<Category> category) {
            this.category = category;
            return this;
        }

        public Builder category(Category category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        @JsonSetter(value="internal_label", nulls=Nulls.SKIP)
        public Builder internalLabel(Optional<String> internalLabel) {
            this.internalLabel = internalLabel;
            return this;
        }

        public Builder internalLabel(String internalLabel) {
            this.internalLabel = Optional.ofNullable(internalLabel);
            return this;
        }

        @JsonSetter(value="external_label", nulls=Nulls.SKIP)
        public Builder externalLabel(Optional<String> externalLabel) {
            this.externalLabel = externalLabel;
            return this;
        }

        public Builder externalLabel(String externalLabel) {
            this.externalLabel = Optional.ofNullable(externalLabel);
            return this;
        }

        @JsonSetter(value="archived", nulls=Nulls.SKIP)
        public Builder archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        public Builder archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        @JsonSetter(value="ticket_types", nulls=Nulls.SKIP)
        public Builder ticketTypes(Optional<TicketTypes> ticketTypes) {
            this.ticketTypes = ticketTypes;
            return this;
        }

        public Builder ticketTypes(TicketTypes ticketTypes) {
            this.ticketTypes = Optional.ofNullable(ticketTypes);
            return this;
        }

        public TicketStateDetailed build() {
            return new TicketStateDetailed(this.type, this.id, this.category, this.internalLabel, this.externalLabel, this.archived, this.ticketTypes, this.additionalProperties);
        }
    }
}

