/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickettypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.Suppliers;
import com.intercom.api.resources.tickets.types.TicketType;
import com.intercom.api.resources.tickettypes.AsyncRawTicketTypesClient;
import com.intercom.api.resources.tickettypes.attributes.AsyncAttributesClient;
import com.intercom.api.resources.tickettypes.requests.FindTicketTypeRequest;
import com.intercom.api.resources.tickettypes.requests.UpdateTicketTypeRequest;
import com.intercom.api.types.CreateTicketTypeRequest;
import com.intercom.api.types.TicketTypeList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncTicketTypesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTicketTypesClient rawClient;
    protected final Supplier<AsyncAttributesClient> attributesClient;

    public AsyncTicketTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketTypesClient(clientOptions);
        this.attributesClient = Suppliers.memoize(() -> new AsyncAttributesClient(clientOptions));
    }

    public AsyncRawTicketTypesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TicketTypeList> list() {
        return this.rawClient.list().thenApply(response -> (TicketTypeList)response.body());
    }

    public CompletableFuture<TicketTypeList> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (TicketTypeList)response.body());
    }

    public CompletableFuture<Optional<TicketType>> create() {
        return this.rawClient.create().thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<TicketType>> create(Optional<CreateTicketTypeRequest> request) {
        return this.rawClient.create(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<TicketType>> create(Optional<CreateTicketTypeRequest> request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<TicketType>> get(FindTicketTypeRequest request) {
        return this.rawClient.get(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<TicketType>> get(FindTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<TicketType>> update(UpdateTicketTypeRequest request) {
        return this.rawClient.update(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<TicketType>> update(UpdateTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public AsyncAttributesClient attributes() {
        return this.attributesClient.get();
    }
}

