/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.admins;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.admins.RawAdminsClient;
import com.intercom.api.resources.unstable.admins.requests.ListActivityLogsRequest;
import com.intercom.api.resources.unstable.admins.requests.RetrieveAdminRequest;
import com.intercom.api.resources.unstable.admins.requests.SetAwayAdminRequest;
import com.intercom.api.resources.unstable.admins.types.Admin;
import com.intercom.api.resources.unstable.types.ActivityLogList;
import com.intercom.api.resources.unstable.types.AdminList;
import com.intercom.api.resources.unstable.types.AdminWithApp;
import java.util.Optional;

public class AdminsClient {
    protected final ClientOptions clientOptions;
    private final RawAdminsClient rawClient;

    public AdminsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawAdminsClient(clientOptions);
    }

    public RawAdminsClient withRawResponse() {
        return this.rawClient;
    }

    public Optional<AdminWithApp> identifyAdmin() {
        return this.rawClient.identifyAdmin().body();
    }

    public Optional<AdminWithApp> identifyAdmin(RequestOptions requestOptions) {
        return this.rawClient.identifyAdmin(requestOptions).body();
    }

    public Optional<Admin> setAwayAdmin(SetAwayAdminRequest request) {
        return this.rawClient.setAwayAdmin(request).body();
    }

    public Optional<Admin> setAwayAdmin(SetAwayAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.setAwayAdmin(request, requestOptions).body();
    }

    public ActivityLogList listActivityLogs(ListActivityLogsRequest request) {
        return this.rawClient.listActivityLogs(request).body();
    }

    public ActivityLogList listActivityLogs(ListActivityLogsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listActivityLogs(request, requestOptions).body();
    }

    public AdminList listAdmins() {
        return this.rawClient.listAdmins().body();
    }

    public AdminList listAdmins(RequestOptions requestOptions) {
        return this.rawClient.listAdmins(requestOptions).body();
    }

    public Optional<Admin> retrieveAdmin(RetrieveAdminRequest request) {
        return this.rawClient.retrieveAdmin(request).body();
    }

    public Optional<Admin> retrieveAdmin(RetrieveAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveAdmin(request, requestOptions).body();
    }
}

