/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.admins;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.admins.AsyncRawAdminsClient;
import com.intercom.api.resources.unstable.admins.requests.ListActivityLogsRequest;
import com.intercom.api.resources.unstable.admins.requests.RetrieveAdminRequest;
import com.intercom.api.resources.unstable.admins.requests.SetAwayAdminRequest;
import com.intercom.api.resources.unstable.admins.types.Admin;
import com.intercom.api.resources.unstable.types.ActivityLogList;
import com.intercom.api.resources.unstable.types.AdminList;
import com.intercom.api.resources.unstable.types.AdminWithApp;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncAdminsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawAdminsClient rawClient;

    public AsyncAdminsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAdminsClient(clientOptions);
    }

    public AsyncRawAdminsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Optional<AdminWithApp>> identifyAdmin() {
        return this.rawClient.identifyAdmin().thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<AdminWithApp>> identifyAdmin(RequestOptions requestOptions) {
        return this.rawClient.identifyAdmin(requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Admin>> setAwayAdmin(SetAwayAdminRequest request) {
        return this.rawClient.setAwayAdmin(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Admin>> setAwayAdmin(SetAwayAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.setAwayAdmin(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<ActivityLogList> listActivityLogs(ListActivityLogsRequest request) {
        return this.rawClient.listActivityLogs(request).thenApply(response -> (ActivityLogList)response.body());
    }

    public CompletableFuture<ActivityLogList> listActivityLogs(ListActivityLogsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listActivityLogs(request, requestOptions).thenApply(response -> (ActivityLogList)response.body());
    }

    public CompletableFuture<AdminList> listAdmins() {
        return this.rawClient.listAdmins().thenApply(response -> (AdminList)response.body());
    }

    public CompletableFuture<AdminList> listAdmins(RequestOptions requestOptions) {
        return this.rawClient.listAdmins(requestOptions).thenApply(response -> (AdminList)response.body());
    }

    public CompletableFuture<Optional<Admin>> retrieveAdmin(RetrieveAdminRequest request) {
        return this.rawClient.retrieveAdmin(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Admin>> retrieveAdmin(RetrieveAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveAdmin(request, requestOptions).thenApply(response -> (Optional)response.body());
    }
}

