/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.aicontent;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.aicontent.AsyncRawAiContentClient;
import com.intercom.api.resources.unstable.aicontent.requests.CreateContentImportSourceRequest;
import com.intercom.api.resources.unstable.aicontent.requests.CreateExternalPageRequest;
import com.intercom.api.resources.unstable.aicontent.requests.DeleteContentImportSourceRequest;
import com.intercom.api.resources.unstable.aicontent.requests.DeleteExternalPageRequest;
import com.intercom.api.resources.unstable.aicontent.requests.GetContentImportSourceRequest;
import com.intercom.api.resources.unstable.aicontent.requests.GetExternalPageRequest;
import com.intercom.api.resources.unstable.aicontent.requests.UpdateContentImportSourceRequest;
import com.intercom.api.resources.unstable.aicontent.requests.UpdateExternalPageRequest;
import com.intercom.api.resources.unstable.aicontent.types.ContentImportSource;
import com.intercom.api.resources.unstable.aicontent.types.ContentImportSourcesList;
import com.intercom.api.resources.unstable.aicontent.types.ExternalPage;
import com.intercom.api.resources.unstable.aicontent.types.ExternalPagesList;
import java.util.concurrent.CompletableFuture;

public class AsyncAiContentClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawAiContentClient rawClient;

    public AsyncAiContentClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAiContentClient(clientOptions);
    }

    public AsyncRawAiContentClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ContentImportSourcesList> listContentImportSources() {
        return this.rawClient.listContentImportSources().thenApply(response -> (ContentImportSourcesList)response.body());
    }

    public CompletableFuture<ContentImportSourcesList> listContentImportSources(RequestOptions requestOptions) {
        return this.rawClient.listContentImportSources(requestOptions).thenApply(response -> (ContentImportSourcesList)response.body());
    }

    public CompletableFuture<ContentImportSource> createContentImportSource(CreateContentImportSourceRequest request) {
        return this.rawClient.createContentImportSource(request).thenApply(response -> (ContentImportSource)response.body());
    }

    public CompletableFuture<ContentImportSource> createContentImportSource(CreateContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.createContentImportSource(request, requestOptions).thenApply(response -> (ContentImportSource)response.body());
    }

    public CompletableFuture<ContentImportSource> getContentImportSource(GetContentImportSourceRequest request) {
        return this.rawClient.getContentImportSource(request).thenApply(response -> (ContentImportSource)response.body());
    }

    public CompletableFuture<ContentImportSource> getContentImportSource(GetContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.getContentImportSource(request, requestOptions).thenApply(response -> (ContentImportSource)response.body());
    }

    public CompletableFuture<ContentImportSource> updateContentImportSource(UpdateContentImportSourceRequest request) {
        return this.rawClient.updateContentImportSource(request).thenApply(response -> (ContentImportSource)response.body());
    }

    public CompletableFuture<ContentImportSource> updateContentImportSource(UpdateContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateContentImportSource(request, requestOptions).thenApply(response -> (ContentImportSource)response.body());
    }

    public CompletableFuture<Void> deleteContentImportSource(DeleteContentImportSourceRequest request) {
        return this.rawClient.deleteContentImportSource(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> deleteContentImportSource(DeleteContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteContentImportSource(request, requestOptions).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<ExternalPagesList> listExternalPages() {
        return this.rawClient.listExternalPages().thenApply(response -> (ExternalPagesList)response.body());
    }

    public CompletableFuture<ExternalPagesList> listExternalPages(RequestOptions requestOptions) {
        return this.rawClient.listExternalPages(requestOptions).thenApply(response -> (ExternalPagesList)response.body());
    }

    public CompletableFuture<ExternalPage> createExternalPage(CreateExternalPageRequest request) {
        return this.rawClient.createExternalPage(request).thenApply(response -> (ExternalPage)response.body());
    }

    public CompletableFuture<ExternalPage> createExternalPage(CreateExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.createExternalPage(request, requestOptions).thenApply(response -> (ExternalPage)response.body());
    }

    public CompletableFuture<ExternalPage> getExternalPage(GetExternalPageRequest request) {
        return this.rawClient.getExternalPage(request).thenApply(response -> (ExternalPage)response.body());
    }

    public CompletableFuture<ExternalPage> getExternalPage(GetExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.getExternalPage(request, requestOptions).thenApply(response -> (ExternalPage)response.body());
    }

    public CompletableFuture<ExternalPage> updateExternalPage(UpdateExternalPageRequest request) {
        return this.rawClient.updateExternalPage(request).thenApply(response -> (ExternalPage)response.body());
    }

    public CompletableFuture<ExternalPage> updateExternalPage(UpdateExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateExternalPage(request, requestOptions).thenApply(response -> (ExternalPage)response.body());
    }

    public CompletableFuture<ExternalPage> deleteExternalPage(DeleteExternalPageRequest request) {
        return this.rawClient.deleteExternalPage(request).thenApply(response -> (ExternalPage)response.body());
    }

    public CompletableFuture<ExternalPage> deleteExternalPage(DeleteExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteExternalPage(request, requestOptions).thenApply(response -> (ExternalPage)response.body());
    }
}

