/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateExternalPageRequest {
    private final String title;
    private final String html;
    private final Optional<String> url;
    private final Optional<Boolean> aiAgentAvailability;
    private final Optional<Boolean> aiCopilotAvailability;
    private final int sourceId;
    private final String externalId;
    private final Map<String, Object> additionalProperties;

    private CreateExternalPageRequest(String title, String html, Optional<String> url, Optional<Boolean> aiAgentAvailability, Optional<Boolean> aiCopilotAvailability, int sourceId, String externalId, Map<String, Object> additionalProperties) {
        this.title = title;
        this.html = html;
        this.url = url;
        this.aiAgentAvailability = aiAgentAvailability;
        this.aiCopilotAvailability = aiCopilotAvailability;
        this.sourceId = sourceId;
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="html")
    public String getHtml() {
        return this.html;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="ai_agent_availability")
    public Optional<Boolean> getAiAgentAvailability() {
        return this.aiAgentAvailability;
    }

    @JsonProperty(value="ai_copilot_availability")
    public Optional<Boolean> getAiCopilotAvailability() {
        return this.aiCopilotAvailability;
    }

    @JsonProperty(value="locale")
    public String getLocale() {
        return "en";
    }

    @JsonProperty(value="source_id")
    public int getSourceId() {
        return this.sourceId;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateExternalPageRequest && this.equalTo((CreateExternalPageRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateExternalPageRequest other) {
        return this.title.equals(other.title) && this.html.equals(other.html) && this.url.equals(other.url) && this.aiAgentAvailability.equals(other.aiAgentAvailability) && this.aiCopilotAvailability.equals(other.aiCopilotAvailability) && this.sourceId == other.sourceId && this.externalId.equals(other.externalId);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.html, this.url, this.aiAgentAvailability, this.aiCopilotAvailability, this.sourceId, this.externalId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    HtmlStage,
    SourceIdStage,
    ExternalIdStage,
    _FinalStage {
        private String title;
        private String html;
        private int sourceId;
        private String externalId;
        private Optional<Boolean> aiCopilotAvailability = Optional.empty();
        private Optional<Boolean> aiAgentAvailability = Optional.empty();
        private Optional<String> url = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateExternalPageRequest other) {
            this.title(other.getTitle());
            this.html(other.getHtml());
            this.url(other.getUrl());
            this.aiAgentAvailability(other.getAiAgentAvailability());
            this.aiCopilotAvailability(other.getAiCopilotAvailability());
            this.sourceId(other.getSourceId());
            this.externalId(other.getExternalId());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public HtmlStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="html")
        public SourceIdStage html(@NotNull String html) {
            this.html = Objects.requireNonNull(html, "html must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="source_id")
        public ExternalIdStage sourceId(int sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public _FinalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        public _FinalStage aiCopilotAvailability(Boolean aiCopilotAvailability) {
            this.aiCopilotAvailability = Optional.ofNullable(aiCopilotAvailability);
            return this;
        }

        @Override
        @JsonSetter(value="ai_copilot_availability", nulls=Nulls.SKIP)
        public _FinalStage aiCopilotAvailability(Optional<Boolean> aiCopilotAvailability) {
            this.aiCopilotAvailability = aiCopilotAvailability;
            return this;
        }

        @Override
        public _FinalStage aiAgentAvailability(Boolean aiAgentAvailability) {
            this.aiAgentAvailability = Optional.ofNullable(aiAgentAvailability);
            return this;
        }

        @Override
        @JsonSetter(value="ai_agent_availability", nulls=Nulls.SKIP)
        public _FinalStage aiAgentAvailability(Optional<Boolean> aiAgentAvailability) {
            this.aiAgentAvailability = aiAgentAvailability;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public CreateExternalPageRequest build() {
            return new CreateExternalPageRequest(this.title, this.html, this.url, this.aiAgentAvailability, this.aiCopilotAvailability, this.sourceId, this.externalId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateExternalPageRequest build();

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);

        public _FinalStage aiAgentAvailability(Optional<Boolean> var1);

        public _FinalStage aiAgentAvailability(Boolean var1);

        public _FinalStage aiCopilotAvailability(Optional<Boolean> var1);

        public _FinalStage aiCopilotAvailability(Boolean var1);
    }

    public static interface ExternalIdStage {
        public _FinalStage externalId(@NotNull String var1);
    }

    public static interface SourceIdStage {
        public ExternalIdStage sourceId(int var1);
    }

    public static interface HtmlStage {
        public SourceIdStage html(@NotNull String var1);
    }

    public static interface TitleStage {
        public HtmlStage title(@NotNull String var1);

        public Builder from(CreateExternalPageRequest var1);
    }
}

