/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.articles;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.articles.AsyncRawArticlesClient;
import com.intercom.api.resources.unstable.articles.requests.DeleteArticleRequest;
import com.intercom.api.resources.unstable.articles.requests.RetrieveArticleRequest;
import com.intercom.api.resources.unstable.articles.requests.SearchArticlesRequest;
import com.intercom.api.resources.unstable.articles.types.Article;
import com.intercom.api.resources.unstable.articles.types.ArticleSearchResponse;
import com.intercom.api.resources.unstable.types.ArticleList;
import com.intercom.api.resources.unstable.types.DeletedArticleObject;
import java.util.concurrent.CompletableFuture;

public class AsyncArticlesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawArticlesClient rawClient;

    public AsyncArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawArticlesClient(clientOptions);
    }

    public AsyncRawArticlesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ArticleList> listArticles() {
        return this.rawClient.listArticles().thenApply(response -> (ArticleList)response.body());
    }

    public CompletableFuture<ArticleList> listArticles(RequestOptions requestOptions) {
        return this.rawClient.listArticles(requestOptions).thenApply(response -> (ArticleList)response.body());
    }

    public CompletableFuture<Article> createArticle(Object request) {
        return this.rawClient.createArticle(request).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<Article> createArticle(Object request, RequestOptions requestOptions) {
        return this.rawClient.createArticle(request, requestOptions).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<Article> retrieveArticle(RetrieveArticleRequest request) {
        return this.rawClient.retrieveArticle(request).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<Article> retrieveArticle(RetrieveArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveArticle(request, requestOptions).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<DeletedArticleObject> deleteArticle(DeleteArticleRequest request) {
        return this.rawClient.deleteArticle(request).thenApply(response -> (DeletedArticleObject)response.body());
    }

    public CompletableFuture<DeletedArticleObject> deleteArticle(DeleteArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteArticle(request, requestOptions).thenApply(response -> (DeletedArticleObject)response.body());
    }

    public CompletableFuture<ArticleSearchResponse> searchArticles() {
        return this.rawClient.searchArticles().thenApply(response -> (ArticleSearchResponse)response.body());
    }

    public CompletableFuture<ArticleSearchResponse> searchArticles(SearchArticlesRequest request) {
        return this.rawClient.searchArticles(request).thenApply(response -> (ArticleSearchResponse)response.body());
    }

    public CompletableFuture<ArticleSearchResponse> searchArticles(SearchArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchArticles(request, requestOptions).thenApply(response -> (ArticleSearchResponse)response.body());
    }
}

