/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.articles.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ArticleSearchHighlights {
    private final Optional<String> articleId;
    private final Optional<List<HighlightedTitleItem>> highlightedTitle;
    private final Optional<List<List<HighlightedSummaryItemItem>>> highlightedSummary;
    private final Map<String, Object> additionalProperties;

    private ArticleSearchHighlights(Optional<String> articleId, Optional<List<HighlightedTitleItem>> highlightedTitle, Optional<List<List<HighlightedSummaryItemItem>>> highlightedSummary, Map<String, Object> additionalProperties) {
        this.articleId = articleId;
        this.highlightedTitle = highlightedTitle;
        this.highlightedSummary = highlightedSummary;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="article_id")
    public Optional<String> getArticleId() {
        return this.articleId;
    }

    @JsonProperty(value="highlighted_title")
    public Optional<List<HighlightedTitleItem>> getHighlightedTitle() {
        return this.highlightedTitle;
    }

    @JsonProperty(value="highlighted_summary")
    public Optional<List<List<HighlightedSummaryItemItem>>> getHighlightedSummary() {
        return this.highlightedSummary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ArticleSearchHighlights && this.equalTo((ArticleSearchHighlights)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleSearchHighlights other) {
        return this.articleId.equals(other.articleId) && this.highlightedTitle.equals(other.highlightedTitle) && this.highlightedSummary.equals(other.highlightedSummary);
    }

    public int hashCode() {
        return Objects.hash(this.articleId, this.highlightedTitle, this.highlightedSummary);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class HighlightedSummaryItemItem {
        private final Optional<Type> type;
        private final Optional<String> text;
        private final Map<String, Object> additionalProperties;

        private HighlightedSummaryItemItem(Optional<Type> type, Optional<String> text, Map<String, Object> additionalProperties) {
            this.type = type;
            this.text = text;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<Type> getType() {
            return this.type;
        }

        @JsonProperty(value="text")
        public Optional<String> getText() {
            return this.text;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof HighlightedSummaryItemItem && this.equalTo((HighlightedSummaryItemItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(HighlightedSummaryItemItem other) {
            return this.type.equals(other.type) && this.text.equals(other.text);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.text);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Type {
            public static final Type PLAIN = new Type(Value.PLAIN, "plain");
            public static final Type HIGHLIGHT = new Type(Value.HIGHLIGHT, "highlight");
            private final Value value;
            private final String string;

            Type(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return this.value;
            }

            @JsonValue
            public String toString() {
                return this.string;
            }

            public boolean equals(Object other) {
                return this == other || other instanceof Type && this.string.equals(((Type)other).string);
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (this.value) {
                    case PLAIN: {
                        return visitor.visitPlain();
                    }
                    case HIGHLIGHT: {
                        return visitor.visitHighlight();
                    }
                }
                return visitor.visitUnknown(this.string);
            }

            @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
            public static Type valueOf(String value) {
                switch (value) {
                    case "plain": {
                        return PLAIN;
                    }
                    case "highlight": {
                        return HIGHLIGHT;
                    }
                }
                return new Type(Value.UNKNOWN, value);
            }

            public static interface Visitor<T> {
                public T visitHighlight();

                public T visitPlain();

                public T visitUnknown(String var1);
            }

            public static enum Value {
                HIGHLIGHT,
                PLAIN,
                UNKNOWN;

            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<Type> type = Optional.empty();
            private Optional<String> text = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(HighlightedSummaryItemItem other) {
                this.type(other.getType());
                this.text(other.getText());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<Type> type) {
                this.type = type;
                return this;
            }

            public Builder type(Type type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="text", nulls=Nulls.SKIP)
            public Builder text(Optional<String> text) {
                this.text = text;
                return this;
            }

            public Builder text(String text) {
                this.text = Optional.ofNullable(text);
                return this;
            }

            public HighlightedSummaryItemItem build() {
                return new HighlightedSummaryItemItem(this.type, this.text, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class HighlightedTitleItem {
        private final Optional<Type> type;
        private final Optional<String> text;
        private final Map<String, Object> additionalProperties;

        private HighlightedTitleItem(Optional<Type> type, Optional<String> text, Map<String, Object> additionalProperties) {
            this.type = type;
            this.text = text;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<Type> getType() {
            return this.type;
        }

        @JsonProperty(value="text")
        public Optional<String> getText() {
            return this.text;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof HighlightedTitleItem && this.equalTo((HighlightedTitleItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(HighlightedTitleItem other) {
            return this.type.equals(other.type) && this.text.equals(other.text);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.text);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Type {
            public static final Type PLAIN = new Type(Value.PLAIN, "plain");
            public static final Type HIGHLIGHT = new Type(Value.HIGHLIGHT, "highlight");
            private final Value value;
            private final String string;

            Type(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return this.value;
            }

            @JsonValue
            public String toString() {
                return this.string;
            }

            public boolean equals(Object other) {
                return this == other || other instanceof Type && this.string.equals(((Type)other).string);
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (this.value) {
                    case PLAIN: {
                        return visitor.visitPlain();
                    }
                    case HIGHLIGHT: {
                        return visitor.visitHighlight();
                    }
                }
                return visitor.visitUnknown(this.string);
            }

            @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
            public static Type valueOf(String value) {
                switch (value) {
                    case "plain": {
                        return PLAIN;
                    }
                    case "highlight": {
                        return HIGHLIGHT;
                    }
                }
                return new Type(Value.UNKNOWN, value);
            }

            public static interface Visitor<T> {
                public T visitHighlight();

                public T visitPlain();

                public T visitUnknown(String var1);
            }

            public static enum Value {
                HIGHLIGHT,
                PLAIN,
                UNKNOWN;

            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<Type> type = Optional.empty();
            private Optional<String> text = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(HighlightedTitleItem other) {
                this.type(other.getType());
                this.text(other.getText());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<Type> type) {
                this.type = type;
                return this;
            }

            public Builder type(Type type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="text", nulls=Nulls.SKIP)
            public Builder text(Optional<String> text) {
                this.text = text;
                return this;
            }

            public Builder text(String text) {
                this.text = Optional.ofNullable(text);
                return this;
            }

            public HighlightedTitleItem build() {
                return new HighlightedTitleItem(this.type, this.text, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> articleId = Optional.empty();
        private Optional<List<HighlightedTitleItem>> highlightedTitle = Optional.empty();
        private Optional<List<List<HighlightedSummaryItemItem>>> highlightedSummary = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ArticleSearchHighlights other) {
            this.articleId(other.getArticleId());
            this.highlightedTitle(other.getHighlightedTitle());
            this.highlightedSummary(other.getHighlightedSummary());
            return this;
        }

        @JsonSetter(value="article_id", nulls=Nulls.SKIP)
        public Builder articleId(Optional<String> articleId) {
            this.articleId = articleId;
            return this;
        }

        public Builder articleId(String articleId) {
            this.articleId = Optional.ofNullable(articleId);
            return this;
        }

        @JsonSetter(value="highlighted_title", nulls=Nulls.SKIP)
        public Builder highlightedTitle(Optional<List<HighlightedTitleItem>> highlightedTitle) {
            this.highlightedTitle = highlightedTitle;
            return this;
        }

        public Builder highlightedTitle(List<HighlightedTitleItem> highlightedTitle) {
            this.highlightedTitle = Optional.ofNullable(highlightedTitle);
            return this;
        }

        @JsonSetter(value="highlighted_summary", nulls=Nulls.SKIP)
        public Builder highlightedSummary(Optional<List<List<HighlightedSummaryItemItem>>> highlightedSummary) {
            this.highlightedSummary = highlightedSummary;
            return this;
        }

        public Builder highlightedSummary(List<List<HighlightedSummaryItemItem>> highlightedSummary) {
            this.highlightedSummary = Optional.ofNullable(highlightedSummary);
            return this;
        }

        public ArticleSearchHighlights build() {
            return new ArticleSearchHighlights(this.articleId, this.highlightedTitle, this.highlightedSummary, this.additionalProperties);
        }
    }
}

