/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.brands;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.brands.AsyncRawBrandsClient;
import com.intercom.api.resources.unstable.brands.requests.RetrieveBrandRequest;
import com.intercom.api.resources.unstable.brands.types.Brand;
import com.intercom.api.resources.unstable.brands.types.BrandList;
import java.util.concurrent.CompletableFuture;

public class AsyncBrandsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawBrandsClient rawClient;

    public AsyncBrandsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawBrandsClient(clientOptions);
    }

    public AsyncRawBrandsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<BrandList> listBrands() {
        return this.rawClient.listBrands().thenApply(response -> (BrandList)response.body());
    }

    public CompletableFuture<BrandList> listBrands(RequestOptions requestOptions) {
        return this.rawClient.listBrands(requestOptions).thenApply(response -> (BrandList)response.body());
    }

    public CompletableFuture<Brand> retrieveBrand(RetrieveBrandRequest request) {
        return this.rawClient.retrieveBrand(request).thenApply(response -> (Brand)response.body());
    }

    public CompletableFuture<Brand> retrieveBrand(RetrieveBrandRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveBrand(request, requestOptions).thenApply(response -> (Brand)response.body());
    }
}

