/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.brands.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Brand {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<Boolean> isDefault;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<String> helpCenterId;
    private final Optional<String> defaultAddressSettingsId;
    private final Map<String, Object> additionalProperties;

    private Brand(Optional<String> type, Optional<String> id, Optional<String> name, Optional<Boolean> isDefault, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<String> helpCenterId, Optional<String> defaultAddressSettingsId, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.isDefault = isDefault;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.helpCenterId = helpCenterId;
        this.defaultAddressSettingsId = defaultAddressSettingsId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="is_default")
    public Optional<Boolean> getIsDefault() {
        return this.isDefault;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="help_center_id")
    public Optional<String> getHelpCenterId() {
        return this.helpCenterId;
    }

    @JsonProperty(value="default_address_settings_id")
    public Optional<String> getDefaultAddressSettingsId() {
        return this.defaultAddressSettingsId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Brand && this.equalTo((Brand)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Brand other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.isDefault.equals(other.isDefault) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.helpCenterId.equals(other.helpCenterId) && this.defaultAddressSettingsId.equals(other.defaultAddressSettingsId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.isDefault, this.createdAt, this.updatedAt, this.helpCenterId, this.defaultAddressSettingsId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Boolean> isDefault = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<String> helpCenterId = Optional.empty();
        private Optional<String> defaultAddressSettingsId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Brand other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.isDefault(other.getIsDefault());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.helpCenterId(other.getHelpCenterId());
            this.defaultAddressSettingsId(other.getDefaultAddressSettingsId());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="is_default", nulls=Nulls.SKIP)
        public Builder isDefault(Optional<Boolean> isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = Optional.ofNullable(isDefault);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="help_center_id", nulls=Nulls.SKIP)
        public Builder helpCenterId(Optional<String> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        public Builder helpCenterId(String helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        @JsonSetter(value="default_address_settings_id", nulls=Nulls.SKIP)
        public Builder defaultAddressSettingsId(Optional<String> defaultAddressSettingsId) {
            this.defaultAddressSettingsId = defaultAddressSettingsId;
            return this;
        }

        public Builder defaultAddressSettingsId(String defaultAddressSettingsId) {
            this.defaultAddressSettingsId = Optional.ofNullable(defaultAddressSettingsId);
            return this;
        }

        public Brand build() {
            return new Brand(this.type, this.id, this.name, this.isDefault, this.createdAt, this.updatedAt, this.helpCenterId, this.defaultAddressSettingsId, this.additionalProperties);
        }
    }
}

