/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.companies.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.notes.types.CompanyNote;
import com.intercom.api.resources.unstable.segments.types.Segment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Company {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> appId;
    private final Optional<Plan> plan;
    private final Optional<String> companyId;
    private final Optional<Integer> remoteCreatedAt;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<Integer> lastRequestAt;
    private final Optional<Integer> size;
    private final Optional<String> website;
    private final Optional<String> industry;
    private final Optional<Integer> monthlySpend;
    private final Optional<Integer> sessionCount;
    private final Optional<Integer> userCount;
    private final Optional<Map<String, String>> customAttributes;
    private final Optional<Tags> tags;
    private final Optional<Segments> segments;
    private final Optional<Notes> notes;
    private final Map<String, Object> additionalProperties;

    private Company(Optional<String> type, Optional<String> id, Optional<String> name, Optional<String> appId, Optional<Plan> plan, Optional<String> companyId, Optional<Integer> remoteCreatedAt, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<Integer> lastRequestAt, Optional<Integer> size, Optional<String> website, Optional<String> industry, Optional<Integer> monthlySpend, Optional<Integer> sessionCount, Optional<Integer> userCount, Optional<Map<String, String>> customAttributes, Optional<Tags> tags, Optional<Segments> segments, Optional<Notes> notes, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.appId = appId;
        this.plan = plan;
        this.companyId = companyId;
        this.remoteCreatedAt = remoteCreatedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.lastRequestAt = lastRequestAt;
        this.size = size;
        this.website = website;
        this.industry = industry;
        this.monthlySpend = monthlySpend;
        this.sessionCount = sessionCount;
        this.userCount = userCount;
        this.customAttributes = customAttributes;
        this.tags = tags;
        this.segments = segments;
        this.notes = notes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="app_id")
    public Optional<String> getAppId() {
        return this.appId;
    }

    @JsonProperty(value="plan")
    public Optional<Plan> getPlan() {
        return this.plan;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<Integer> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="last_request_at")
    public Optional<Integer> getLastRequestAt() {
        return this.lastRequestAt;
    }

    @JsonProperty(value="size")
    public Optional<Integer> getSize() {
        return this.size;
    }

    @JsonProperty(value="website")
    public Optional<String> getWebsite() {
        return this.website;
    }

    @JsonProperty(value="industry")
    public Optional<String> getIndustry() {
        return this.industry;
    }

    @JsonProperty(value="monthly_spend")
    public Optional<Integer> getMonthlySpend() {
        return this.monthlySpend;
    }

    @JsonProperty(value="session_count")
    public Optional<Integer> getSessionCount() {
        return this.sessionCount;
    }

    @JsonProperty(value="user_count")
    public Optional<Integer> getUserCount() {
        return this.userCount;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, String>> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonProperty(value="tags")
    public Optional<Tags> getTags() {
        return this.tags;
    }

    @JsonProperty(value="segments")
    public Optional<Segments> getSegments() {
        return this.segments;
    }

    @JsonProperty(value="notes")
    public Optional<Notes> getNotes() {
        return this.notes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Company && this.equalTo((Company)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Company other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.appId.equals(other.appId) && this.plan.equals(other.plan) && this.companyId.equals(other.companyId) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.lastRequestAt.equals(other.lastRequestAt) && this.size.equals(other.size) && this.website.equals(other.website) && this.industry.equals(other.industry) && this.monthlySpend.equals(other.monthlySpend) && this.sessionCount.equals(other.sessionCount) && this.userCount.equals(other.userCount) && this.customAttributes.equals(other.customAttributes) && this.tags.equals(other.tags) && this.segments.equals(other.segments) && this.notes.equals(other.notes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.appId, this.plan, this.companyId, this.remoteCreatedAt, this.createdAt, this.updatedAt, this.lastRequestAt, this.size, this.website, this.industry, this.monthlySpend, this.sessionCount, this.userCount, this.customAttributes, this.tags, this.segments, this.notes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Notes {
        private final Optional<String> type;
        private final Optional<List<CompanyNote>> notes;
        private final Map<String, Object> additionalProperties;

        private Notes(Optional<String> type, Optional<List<CompanyNote>> notes, Map<String, Object> additionalProperties) {
            this.type = type;
            this.notes = notes;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="notes")
        public Optional<List<CompanyNote>> getNotes() {
            return this.notes;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Notes && this.equalTo((Notes)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Notes other) {
            return this.type.equals(other.type) && this.notes.equals(other.notes);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.notes);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<CompanyNote>> notes = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Notes other) {
                this.type(other.getType());
                this.notes(other.getNotes());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="notes", nulls=Nulls.SKIP)
            public Builder notes(Optional<List<CompanyNote>> notes) {
                this.notes = notes;
                return this;
            }

            public Builder notes(List<CompanyNote> notes) {
                this.notes = Optional.ofNullable(notes);
                return this;
            }

            public Notes build() {
                return new Notes(this.type, this.notes, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Segments {
        private final Optional<String> type;
        private final Optional<List<Segment>> segments;
        private final Map<String, Object> additionalProperties;

        private Segments(Optional<String> type, Optional<List<Segment>> segments, Map<String, Object> additionalProperties) {
            this.type = type;
            this.segments = segments;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="segments")
        public Optional<List<Segment>> getSegments() {
            return this.segments;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Segments && this.equalTo((Segments)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Segments other) {
            return this.type.equals(other.type) && this.segments.equals(other.segments);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.segments);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<Segment>> segments = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Segments other) {
                this.type(other.getType());
                this.segments(other.getSegments());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="segments", nulls=Nulls.SKIP)
            public Builder segments(Optional<List<Segment>> segments) {
                this.segments = segments;
                return this;
            }

            public Builder segments(List<Segment> segments) {
                this.segments = Optional.ofNullable(segments);
                return this;
            }

            public Segments build() {
                return new Segments(this.type, this.segments, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Tags {
        private final Optional<String> type;
        private final Optional<List<Object>> tags;
        private final Map<String, Object> additionalProperties;

        private Tags(Optional<String> type, Optional<List<Object>> tags, Map<String, Object> additionalProperties) {
            this.type = type;
            this.tags = tags;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="tags")
        public Optional<List<Object>> getTags() {
            return this.tags;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Tags && this.equalTo((Tags)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Tags other) {
            return this.type.equals(other.type) && this.tags.equals(other.tags);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.tags);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<Object>> tags = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Tags other) {
                this.type(other.getType());
                this.tags(other.getTags());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="tags", nulls=Nulls.SKIP)
            public Builder tags(Optional<List<Object>> tags) {
                this.tags = tags;
                return this;
            }

            public Builder tags(List<Object> tags) {
                this.tags = Optional.ofNullable(tags);
                return this;
            }

            public Tags build() {
                return new Tags(this.type, this.tags, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Plan {
        private final Optional<String> type;
        private final Optional<String> id;
        private final Optional<String> name;
        private final Map<String, Object> additionalProperties;

        private Plan(Optional<String> type, Optional<String> id, Optional<String> name, Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="id")
        public Optional<String> getId() {
            return this.id;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Plan && this.equalTo((Plan)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Plan other) {
            return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.id, this.name);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<String> id = Optional.empty();
            private Optional<String> name = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Plan other) {
                this.type(other.getType());
                this.id(other.getId());
                this.name(other.getName());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="id", nulls=Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Plan build() {
                return new Plan(this.type, this.id, this.name, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> appId = Optional.empty();
        private Optional<Plan> plan = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<Integer> remoteCreatedAt = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<Integer> lastRequestAt = Optional.empty();
        private Optional<Integer> size = Optional.empty();
        private Optional<String> website = Optional.empty();
        private Optional<String> industry = Optional.empty();
        private Optional<Integer> monthlySpend = Optional.empty();
        private Optional<Integer> sessionCount = Optional.empty();
        private Optional<Integer> userCount = Optional.empty();
        private Optional<Map<String, String>> customAttributes = Optional.empty();
        private Optional<Tags> tags = Optional.empty();
        private Optional<Segments> segments = Optional.empty();
        private Optional<Notes> notes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Company other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.appId(other.getAppId());
            this.plan(other.getPlan());
            this.companyId(other.getCompanyId());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.lastRequestAt(other.getLastRequestAt());
            this.size(other.getSize());
            this.website(other.getWebsite());
            this.industry(other.getIndustry());
            this.monthlySpend(other.getMonthlySpend());
            this.sessionCount(other.getSessionCount());
            this.userCount(other.getUserCount());
            this.customAttributes(other.getCustomAttributes());
            this.tags(other.getTags());
            this.segments(other.getSegments());
            this.notes(other.getNotes());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="app_id", nulls=Nulls.SKIP)
        public Builder appId(Optional<String> appId) {
            this.appId = appId;
            return this;
        }

        public Builder appId(String appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        @JsonSetter(value="plan", nulls=Nulls.SKIP)
        public Builder plan(Optional<Plan> plan) {
            this.plan = plan;
            return this;
        }

        public Builder plan(Plan plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<Integer> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(Integer remoteCreatedAt) {
            this.remoteCreatedAt = Optional.ofNullable(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="last_request_at", nulls=Nulls.SKIP)
        public Builder lastRequestAt(Optional<Integer> lastRequestAt) {
            this.lastRequestAt = lastRequestAt;
            return this;
        }

        public Builder lastRequestAt(Integer lastRequestAt) {
            this.lastRequestAt = Optional.ofNullable(lastRequestAt);
            return this;
        }

        @JsonSetter(value="size", nulls=Nulls.SKIP)
        public Builder size(Optional<Integer> size) {
            this.size = size;
            return this;
        }

        public Builder size(Integer size) {
            this.size = Optional.ofNullable(size);
            return this;
        }

        @JsonSetter(value="website", nulls=Nulls.SKIP)
        public Builder website(Optional<String> website) {
            this.website = website;
            return this;
        }

        public Builder website(String website) {
            this.website = Optional.ofNullable(website);
            return this;
        }

        @JsonSetter(value="industry", nulls=Nulls.SKIP)
        public Builder industry(Optional<String> industry) {
            this.industry = industry;
            return this;
        }

        public Builder industry(String industry) {
            this.industry = Optional.ofNullable(industry);
            return this;
        }

        @JsonSetter(value="monthly_spend", nulls=Nulls.SKIP)
        public Builder monthlySpend(Optional<Integer> monthlySpend) {
            this.monthlySpend = monthlySpend;
            return this;
        }

        public Builder monthlySpend(Integer monthlySpend) {
            this.monthlySpend = Optional.ofNullable(monthlySpend);
            return this;
        }

        @JsonSetter(value="session_count", nulls=Nulls.SKIP)
        public Builder sessionCount(Optional<Integer> sessionCount) {
            this.sessionCount = sessionCount;
            return this;
        }

        public Builder sessionCount(Integer sessionCount) {
            this.sessionCount = Optional.ofNullable(sessionCount);
            return this;
        }

        @JsonSetter(value="user_count", nulls=Nulls.SKIP)
        public Builder userCount(Optional<Integer> userCount) {
            this.userCount = userCount;
            return this;
        }

        public Builder userCount(Integer userCount) {
            this.userCount = Optional.ofNullable(userCount);
            return this;
        }

        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public Builder customAttributes(Optional<Map<String, String>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder customAttributes(Map<String, String> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public Builder tags(Optional<Tags> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @JsonSetter(value="segments", nulls=Nulls.SKIP)
        public Builder segments(Optional<Segments> segments) {
            this.segments = segments;
            return this;
        }

        public Builder segments(Segments segments) {
            this.segments = Optional.ofNullable(segments);
            return this;
        }

        @JsonSetter(value="notes", nulls=Nulls.SKIP)
        public Builder notes(Optional<Notes> notes) {
            this.notes = notes;
            return this;
        }

        public Builder notes(Notes notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        public Company build() {
            return new Company(this.type, this.id, this.name, this.appId, this.plan, this.companyId, this.remoteCreatedAt, this.createdAt, this.updatedAt, this.lastRequestAt, this.size, this.website, this.industry, this.monthlySpend, this.sessionCount, this.userCount, this.customAttributes, this.tags, this.segments, this.notes, this.additionalProperties);
        }
    }
}

