/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.conversations;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.conversations.AsyncRawConversationsClient;
import com.intercom.api.resources.unstable.conversations.requests.AttachContactToConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.ConvertConversationToTicketRequest;
import com.intercom.api.resources.unstable.conversations.requests.CreateConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.DeleteConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.DetachContactFromConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.ListConversationsRequest;
import com.intercom.api.resources.unstable.conversations.requests.ListHandlingEventsRequest;
import com.intercom.api.resources.unstable.conversations.requests.ManageConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.ReplyConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.RetrieveConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.UpdateConversationRequest;
import com.intercom.api.resources.unstable.conversations.types.Conversation;
import com.intercom.api.resources.unstable.messages.types.Message;
import com.intercom.api.resources.unstable.tickets.types.Ticket;
import com.intercom.api.resources.unstable.types.ConversationDeleted;
import com.intercom.api.resources.unstable.types.ConversationList;
import com.intercom.api.resources.unstable.types.HandlingEventList;
import com.intercom.api.resources.unstable.types.RedactConversationRequest;
import com.intercom.api.resources.unstable.types.SearchRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncConversationsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawConversationsClient rawClient;

    public AsyncConversationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawConversationsClient(clientOptions);
    }

    public AsyncRawConversationsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ConversationList> listConversations() {
        return this.rawClient.listConversations().thenApply(response -> (ConversationList)response.body());
    }

    public CompletableFuture<ConversationList> listConversations(ListConversationsRequest request) {
        return this.rawClient.listConversations(request).thenApply(response -> (ConversationList)response.body());
    }

    public CompletableFuture<ConversationList> listConversations(ListConversationsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listConversations(request, requestOptions).thenApply(response -> (ConversationList)response.body());
    }

    public CompletableFuture<Message> createConversation(CreateConversationRequest request) {
        return this.rawClient.createConversation(request).thenApply(response -> (Message)response.body());
    }

    public CompletableFuture<Message> createConversation(CreateConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.createConversation(request, requestOptions).thenApply(response -> (Message)response.body());
    }

    public CompletableFuture<Conversation> retrieveConversation(RetrieveConversationRequest request) {
        return this.rawClient.retrieveConversation(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> retrieveConversation(RetrieveConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveConversation(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> updateConversation(UpdateConversationRequest request) {
        return this.rawClient.updateConversation(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> updateConversation(UpdateConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateConversation(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<ConversationDeleted> deleteConversation(DeleteConversationRequest request) {
        return this.rawClient.deleteConversation(request).thenApply(response -> (ConversationDeleted)response.body());
    }

    public CompletableFuture<ConversationDeleted> deleteConversation(DeleteConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteConversation(request, requestOptions).thenApply(response -> (ConversationDeleted)response.body());
    }

    public CompletableFuture<ConversationList> searchConversations(SearchRequest request) {
        return this.rawClient.searchConversations(request).thenApply(response -> (ConversationList)response.body());
    }

    public CompletableFuture<ConversationList> searchConversations(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchConversations(request, requestOptions).thenApply(response -> (ConversationList)response.body());
    }

    public CompletableFuture<Conversation> replyConversation(ReplyConversationRequest request) {
        return this.rawClient.replyConversation(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> replyConversation(ReplyConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.replyConversation(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> manageConversation(ManageConversationRequest request) {
        return this.rawClient.manageConversation(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> manageConversation(ManageConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.manageConversation(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> attachContactToConversation(AttachContactToConversationRequest request) {
        return this.rawClient.attachContactToConversation(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> attachContactToConversation(AttachContactToConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachContactToConversation(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> detachContactFromConversation(DetachContactFromConversationRequest request) {
        return this.rawClient.detachContactFromConversation(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> detachContactFromConversation(DetachContactFromConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachContactFromConversation(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<HandlingEventList> listHandlingEvents(ListHandlingEventsRequest request) {
        return this.rawClient.listHandlingEvents(request).thenApply(response -> (HandlingEventList)response.body());
    }

    public CompletableFuture<HandlingEventList> listHandlingEvents(ListHandlingEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listHandlingEvents(request, requestOptions).thenApply(response -> (HandlingEventList)response.body());
    }

    public CompletableFuture<Conversation> redactConversation(RedactConversationRequest request) {
        return this.rawClient.redactConversation(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> redactConversation(RedactConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.redactConversation(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Optional<Ticket>> convertConversationToTicket(ConvertConversationToTicketRequest request) {
        return this.rawClient.convertConversationToTicket(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Ticket>> convertConversationToTicket(ConvertConversationToTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.convertConversationToTicket(request, requestOptions).thenApply(response -> (Optional)response.body());
    }
}

