/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ReplyConversationRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ReplyConversationRequest {
    private final String id;
    private final ReplyConversationRequestBody body;
    private final Map<String, Object> additionalProperties;

    private ReplyConversationRequest(String id, ReplyConversationRequestBody body, Map<String, Object> additionalProperties) {
        this.id = id;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="body")
    public ReplyConversationRequestBody getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ReplyConversationRequest && this.equalTo((ReplyConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ReplyConversationRequest other) {
        return this.id.equals(other.id) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    BodyStage,
    _FinalStage {
        private String id;
        private ReplyConversationRequestBody body;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ReplyConversationRequest other) {
            this.id(other.getId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public BodyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull ReplyConversationRequestBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public ReplyConversationRequest build() {
            return new ReplyConversationRequest(this.id, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ReplyConversationRequest build();
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull ReplyConversationRequestBody var1);
    }

    public static interface IdStage {
        public BodyStage id(@NotNull String var1);

        public Builder from(ReplyConversationRequest var1);
    }
}

