/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.customobjectinstances.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomObjectInstance {
    private final Optional<String> id;
    private final Optional<String> externalId;
    private final Optional<Integer> externalCreatedAt;
    private final Optional<Integer> externalUpdatedAt;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<String> type;
    private final Optional<Map<String, String>> customAttributes;
    private final Map<String, Object> additionalProperties;

    private CustomObjectInstance(Optional<String> id, Optional<String> externalId, Optional<Integer> externalCreatedAt, Optional<Integer> externalUpdatedAt, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<String> type, Optional<Map<String, String>> customAttributes, Map<String, Object> additionalProperties) {
        this.id = id;
        this.externalId = externalId;
        this.externalCreatedAt = externalCreatedAt;
        this.externalUpdatedAt = externalUpdatedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.type = type;
        this.customAttributes = customAttributes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="external_created_at")
    public Optional<Integer> getExternalCreatedAt() {
        return this.externalCreatedAt;
    }

    @JsonProperty(value="external_updated_at")
    public Optional<Integer> getExternalUpdatedAt() {
        return this.externalUpdatedAt;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, String>> getCustomAttributes() {
        return this.customAttributes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomObjectInstance && this.equalTo((CustomObjectInstance)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomObjectInstance other) {
        return this.id.equals(other.id) && this.externalId.equals(other.externalId) && this.externalCreatedAt.equals(other.externalCreatedAt) && this.externalUpdatedAt.equals(other.externalUpdatedAt) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.type.equals(other.type) && this.customAttributes.equals(other.customAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.externalId, this.externalCreatedAt, this.externalUpdatedAt, this.createdAt, this.updatedAt, this.type, this.customAttributes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<Integer> externalCreatedAt = Optional.empty();
        private Optional<Integer> externalUpdatedAt = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<String> type = Optional.empty();
        private Optional<Map<String, String>> customAttributes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomObjectInstance other) {
            this.id(other.getId());
            this.externalId(other.getExternalId());
            this.externalCreatedAt(other.getExternalCreatedAt());
            this.externalUpdatedAt(other.getExternalUpdatedAt());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.type(other.getType());
            this.customAttributes(other.getCustomAttributes());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public Builder externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @JsonSetter(value="external_created_at", nulls=Nulls.SKIP)
        public Builder externalCreatedAt(Optional<Integer> externalCreatedAt) {
            this.externalCreatedAt = externalCreatedAt;
            return this;
        }

        public Builder externalCreatedAt(Integer externalCreatedAt) {
            this.externalCreatedAt = Optional.ofNullable(externalCreatedAt);
            return this;
        }

        @JsonSetter(value="external_updated_at", nulls=Nulls.SKIP)
        public Builder externalUpdatedAt(Optional<Integer> externalUpdatedAt) {
            this.externalUpdatedAt = externalUpdatedAt;
            return this;
        }

        public Builder externalUpdatedAt(Integer externalUpdatedAt) {
            this.externalUpdatedAt = Optional.ofNullable(externalUpdatedAt);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public Builder customAttributes(Optional<Map<String, String>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder customAttributes(Map<String, String> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        public CustomObjectInstance build() {
            return new CustomObjectInstance(this.id, this.externalId, this.externalCreatedAt, this.externalUpdatedAt, this.createdAt, this.updatedAt, this.type, this.customAttributes, this.additionalProperties);
        }
    }
}

