/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.dataattributes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.dataattributes.AsyncRawDataAttributesClient;
import com.intercom.api.resources.unstable.dataattributes.requests.LisDataAttributesRequest;
import com.intercom.api.resources.unstable.dataattributes.requests.UpdateDataAttributeRequest;
import com.intercom.api.resources.unstable.dataattributes.types.DataAttribute;
import com.intercom.api.resources.unstable.types.DataAttributeList;
import java.util.concurrent.CompletableFuture;

public class AsyncDataAttributesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDataAttributesClient rawClient;

    public AsyncDataAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDataAttributesClient(clientOptions);
    }

    public AsyncRawDataAttributesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<DataAttributeList> lisDataAttributes() {
        return this.rawClient.lisDataAttributes().thenApply(response -> (DataAttributeList)response.body());
    }

    public CompletableFuture<DataAttributeList> lisDataAttributes(LisDataAttributesRequest request) {
        return this.rawClient.lisDataAttributes(request).thenApply(response -> (DataAttributeList)response.body());
    }

    public CompletableFuture<DataAttributeList> lisDataAttributes(LisDataAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.lisDataAttributes(request, requestOptions).thenApply(response -> (DataAttributeList)response.body());
    }

    public CompletableFuture<DataAttribute> createDataAttribute(Object request) {
        return this.rawClient.createDataAttribute(request).thenApply(response -> (DataAttribute)response.body());
    }

    public CompletableFuture<DataAttribute> createDataAttribute(Object request, RequestOptions requestOptions) {
        return this.rawClient.createDataAttribute(request, requestOptions).thenApply(response -> (DataAttribute)response.body());
    }

    public CompletableFuture<DataAttribute> updateDataAttribute(UpdateDataAttributeRequest request) {
        return this.rawClient.updateDataAttribute(request).thenApply(response -> (DataAttribute)response.body());
    }

    public CompletableFuture<DataAttribute> updateDataAttribute(UpdateDataAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateDataAttribute(request, requestOptions).thenApply(response -> (DataAttribute)response.body());
    }
}

