/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.dataevents;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.QueryStringMapper;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.dataevents.requests.CreateDataEventSummariesRequest;
import com.intercom.api.resources.unstable.dataevents.requests.LisDataEventsRequest;
import com.intercom.api.resources.unstable.errors.UnauthorizedError;
import com.intercom.api.resources.unstable.types.DataEventSummary;
import com.intercom.api.resources.unstable.types.Error;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawDataEventsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawDataEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<IntercomHttpResponse<DataEventSummary>> lisDataEvents(LisDataEventsRequest request) {
        return this.lisDataEvents(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<DataEventSummary>> lisDataEvents(LisDataEventsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("events");
        QueryStringMapper.addQueryParameter(httpUrl, "filter", request.getFilter(), false);
        QueryStringMapper.addQueryParameter(httpUrl, "type", request.getType(), false);
        if (request.getSummary().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "summary", request.getSummary().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<IntercomHttpResponse<DataEventSummary>> future = new CompletableFuture<IntercomHttpResponse<DataEventSummary>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Loose catch block
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    String responseBodyString;
                    ResponseBody responseBody;
                    block13: {
                        block14: {
                            block11: {
                                block12: {
                                    responseBody = response.body();
                                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                                    if (!response.isSuccessful()) break block11;
                                    future.complete(new IntercomHttpResponse<DataEventSummary>((DataEventSummary)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataEventSummary.class), response));
                                    if (responseBody == null) break block12;
                                    responseBody.close();
                                }
                                return;
                            }
                            if (response.code() != 401) break block13;
                            future.completeExceptionally(new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response));
                            if (responseBody == null) break block14;
                            responseBody.close();
                        }
                        return;
                    }
                    try {
                        block15: {
                            break block15;
                            catch (JsonProcessingException jsonProcessingException) {
                                // empty catch block
                            }
                        }
                        Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                        future.completeExceptionally(new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response));
                        return;
                    }
                    finally {
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<IntercomHttpResponse<Void>> createDataEvent(Object request) {
        return this.createDataEvent(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<Void>> createDataEvent(Object request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("events").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<IntercomHttpResponse<Void>> future = new CompletableFuture<IntercomHttpResponse<Void>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<Object>(null, response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        if (response.code() == 401) {
                            future.completeExceptionally(new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response));
                            return;
                        }
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        // empty catch block
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<IntercomHttpResponse<Void>> dataEventSummaries() {
        return this.dataEventSummaries(CreateDataEventSummariesRequest.builder().build());
    }

    public CompletableFuture<IntercomHttpResponse<Void>> dataEventSummaries(CreateDataEventSummariesRequest request) {
        return this.dataEventSummaries(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<Void>> dataEventSummaries(CreateDataEventSummariesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("events/summaries").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<IntercomHttpResponse<Void>> future = new CompletableFuture<IntercomHttpResponse<Void>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<Object>(null, response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        if (response.code() == 401) {
                            future.completeExceptionally(new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response));
                            return;
                        }
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        // empty catch block
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

