/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.GroupTranslatedContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Collection {
    private final Optional<String> id;
    private final Optional<String> workspaceId;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<String> url;
    private final Optional<String> icon;
    private final Optional<Integer> order;
    private final Optional<String> defaultLocale;
    private final Optional<GroupTranslatedContent> translatedContent;
    private final Optional<String> parentId;
    private final Optional<Integer> helpCenterId;
    private final Map<String, Object> additionalProperties;

    private Collection(Optional<String> id, Optional<String> workspaceId, Optional<String> name, Optional<String> description, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<String> url, Optional<String> icon, Optional<Integer> order, Optional<String> defaultLocale, Optional<GroupTranslatedContent> translatedContent, Optional<String> parentId, Optional<Integer> helpCenterId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.name = name;
        this.description = description;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.icon = icon;
        this.order = order;
        this.defaultLocale = defaultLocale;
        this.translatedContent = translatedContent;
        this.parentId = parentId;
        this.helpCenterId = helpCenterId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="workspace_id")
    public Optional<String> getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="order")
    public Optional<Integer> getOrder() {
        return this.order;
    }

    @JsonProperty(value="default_locale")
    public Optional<String> getDefaultLocale() {
        return this.defaultLocale;
    }

    @JsonProperty(value="translated_content")
    public Optional<GroupTranslatedContent> getTranslatedContent() {
        return this.translatedContent;
    }

    @JsonProperty(value="parent_id")
    public Optional<String> getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="help_center_id")
    public Optional<Integer> getHelpCenterId() {
        return this.helpCenterId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Collection && this.equalTo((Collection)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Collection other) {
        return this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.name.equals(other.name) && this.description.equals(other.description) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.url.equals(other.url) && this.icon.equals(other.icon) && this.order.equals(other.order) && this.defaultLocale.equals(other.defaultLocale) && this.translatedContent.equals(other.translatedContent) && this.parentId.equals(other.parentId) && this.helpCenterId.equals(other.helpCenterId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.workspaceId, this.name, this.description, this.createdAt, this.updatedAt, this.url, this.icon, this.order, this.defaultLocale, this.translatedContent, this.parentId, this.helpCenterId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> workspaceId = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> icon = Optional.empty();
        private Optional<Integer> order = Optional.empty();
        private Optional<String> defaultLocale = Optional.empty();
        private Optional<GroupTranslatedContent> translatedContent = Optional.empty();
        private Optional<String> parentId = Optional.empty();
        private Optional<Integer> helpCenterId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Collection other) {
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.url(other.getUrl());
            this.icon(other.getIcon());
            this.order(other.getOrder());
            this.defaultLocale(other.getDefaultLocale());
            this.translatedContent(other.getTranslatedContent());
            this.parentId(other.getParentId());
            this.helpCenterId(other.getHelpCenterId());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="workspace_id", nulls=Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @JsonSetter(value="icon", nulls=Nulls.SKIP)
        public Builder icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public Builder order(Optional<Integer> order) {
            this.order = order;
            return this;
        }

        public Builder order(Integer order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @JsonSetter(value="default_locale", nulls=Nulls.SKIP)
        public Builder defaultLocale(Optional<String> defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        public Builder defaultLocale(String defaultLocale) {
            this.defaultLocale = Optional.ofNullable(defaultLocale);
            return this;
        }

        @JsonSetter(value="translated_content", nulls=Nulls.SKIP)
        public Builder translatedContent(Optional<GroupTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        public Builder translatedContent(GroupTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        @JsonSetter(value="parent_id", nulls=Nulls.SKIP)
        public Builder parentId(Optional<String> parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        @JsonSetter(value="help_center_id", nulls=Nulls.SKIP)
        public Builder helpCenterId(Optional<Integer> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        public Builder helpCenterId(Integer helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        public Collection build() {
            return new Collection(this.id, this.workspaceId, this.name, this.description, this.createdAt, this.updatedAt, this.url, this.icon, this.order, this.defaultLocale, this.translatedContent, this.parentId, this.helpCenterId, this.additionalProperties);
        }
    }
}

