/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.messages.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetWhatsAppMessageStatusRequest {
    private final String rulesetId;
    private final Optional<Integer> perPage;
    private final Optional<String> startingAfter;
    private final Map<String, Object> additionalProperties;

    private GetWhatsAppMessageStatusRequest(String rulesetId, Optional<Integer> perPage, Optional<String> startingAfter, Map<String, Object> additionalProperties) {
        this.rulesetId = rulesetId;
        this.perPage = perPage;
        this.startingAfter = startingAfter;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ruleset_id")
    public String getRulesetId() {
        return this.rulesetId;
    }

    @JsonProperty(value="per_page")
    public Optional<Integer> getPerPage() {
        return this.perPage;
    }

    @JsonProperty(value="starting_after")
    public Optional<String> getStartingAfter() {
        return this.startingAfter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetWhatsAppMessageStatusRequest && this.equalTo((GetWhatsAppMessageStatusRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetWhatsAppMessageStatusRequest other) {
        return this.rulesetId.equals(other.rulesetId) && this.perPage.equals(other.perPage) && this.startingAfter.equals(other.startingAfter);
    }

    public int hashCode() {
        return Objects.hash(this.rulesetId, this.perPage, this.startingAfter);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RulesetIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RulesetIdStage,
    _FinalStage {
        private String rulesetId;
        private Optional<String> startingAfter = Optional.empty();
        private Optional<Integer> perPage = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetWhatsAppMessageStatusRequest other) {
            this.rulesetId(other.getRulesetId());
            this.perPage(other.getPerPage());
            this.startingAfter(other.getStartingAfter());
            return this;
        }

        @Override
        @JsonSetter(value="ruleset_id")
        public _FinalStage rulesetId(@NotNull String rulesetId) {
            this.rulesetId = Objects.requireNonNull(rulesetId, "rulesetId must not be null");
            return this;
        }

        @Override
        public _FinalStage startingAfter(String startingAfter) {
            this.startingAfter = Optional.ofNullable(startingAfter);
            return this;
        }

        @Override
        @JsonSetter(value="starting_after", nulls=Nulls.SKIP)
        public _FinalStage startingAfter(Optional<String> startingAfter) {
            this.startingAfter = startingAfter;
            return this;
        }

        @Override
        public _FinalStage perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        @Override
        @JsonSetter(value="per_page", nulls=Nulls.SKIP)
        public _FinalStage perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        @Override
        public GetWhatsAppMessageStatusRequest build() {
            return new GetWhatsAppMessageStatusRequest(this.rulesetId, this.perPage, this.startingAfter, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetWhatsAppMessageStatusRequest build();

        public _FinalStage perPage(Optional<Integer> var1);

        public _FinalStage perPage(Integer var1);

        public _FinalStage startingAfter(Optional<String> var1);

        public _FinalStage startingAfter(String var1);
    }

    public static interface RulesetIdStage {
        public _FinalStage rulesetId(@NotNull String var1);

        public Builder from(GetWhatsAppMessageStatusRequest var1);
    }
}

