/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.news;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.news.AsyncRawNewsClient;
import com.intercom.api.resources.unstable.news.requests.DeleteNewsItemRequest;
import com.intercom.api.resources.unstable.news.requests.ListLiveNewsfeedItemsRequest;
import com.intercom.api.resources.unstable.news.requests.RetrieveNewsItemRequest;
import com.intercom.api.resources.unstable.news.requests.RetrieveNewsfeedRequest;
import com.intercom.api.resources.unstable.news.requests.UpdateNewsItemRequest;
import com.intercom.api.resources.unstable.news.types.NewsItem;
import com.intercom.api.resources.unstable.news.types.Newsfeed;
import com.intercom.api.resources.unstable.types.DeletedObject;
import com.intercom.api.resources.unstable.types.NewsItemRequest;
import com.intercom.api.resources.unstable.types.PaginatedResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncNewsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawNewsClient rawClient;

    public AsyncNewsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawNewsClient(clientOptions);
    }

    public AsyncRawNewsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<PaginatedResponse> listNewsItems() {
        return this.rawClient.listNewsItems().thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<PaginatedResponse> listNewsItems(RequestOptions requestOptions) {
        return this.rawClient.listNewsItems(requestOptions).thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<NewsItem> createNewsItem(NewsItemRequest request) {
        return this.rawClient.createNewsItem(request).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> createNewsItem(NewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.createNewsItem(request, requestOptions).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> retrieveNewsItem(RetrieveNewsItemRequest request) {
        return this.rawClient.retrieveNewsItem(request).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> retrieveNewsItem(RetrieveNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveNewsItem(request, requestOptions).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> updateNewsItem(UpdateNewsItemRequest request) {
        return this.rawClient.updateNewsItem(request).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> updateNewsItem(UpdateNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateNewsItem(request, requestOptions).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<DeletedObject> deleteNewsItem(DeleteNewsItemRequest request) {
        return this.rawClient.deleteNewsItem(request).thenApply(response -> (DeletedObject)response.body());
    }

    public CompletableFuture<DeletedObject> deleteNewsItem(DeleteNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteNewsItem(request, requestOptions).thenApply(response -> (DeletedObject)response.body());
    }

    public CompletableFuture<PaginatedResponse> listLiveNewsfeedItems(ListLiveNewsfeedItemsRequest request) {
        return this.rawClient.listLiveNewsfeedItems(request).thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<PaginatedResponse> listLiveNewsfeedItems(ListLiveNewsfeedItemsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listLiveNewsfeedItems(request, requestOptions).thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<PaginatedResponse> listNewsfeeds() {
        return this.rawClient.listNewsfeeds().thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<PaginatedResponse> listNewsfeeds(RequestOptions requestOptions) {
        return this.rawClient.listNewsfeeds(requestOptions).thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<Newsfeed> retrieveNewsfeed(RetrieveNewsfeedRequest request) {
        return this.rawClient.retrieveNewsfeed(request).thenApply(response -> (Newsfeed)response.body());
    }

    public CompletableFuture<Newsfeed> retrieveNewsfeed(RetrieveNewsfeedRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveNewsfeed(request, requestOptions).thenApply(response -> (Newsfeed)response.body());
    }
}

