/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.news.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class NewsfeedAssignment {
    private final Optional<Integer> newsfeedId;
    private final Optional<Integer> publishedAt;
    private final Map<String, Object> additionalProperties;

    private NewsfeedAssignment(Optional<Integer> newsfeedId, Optional<Integer> publishedAt, Map<String, Object> additionalProperties) {
        this.newsfeedId = newsfeedId;
        this.publishedAt = publishedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="newsfeed_id")
    public Optional<Integer> getNewsfeedId() {
        return this.newsfeedId;
    }

    @JsonProperty(value="published_at")
    public Optional<Integer> getPublishedAt() {
        return this.publishedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NewsfeedAssignment && this.equalTo((NewsfeedAssignment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NewsfeedAssignment other) {
        return this.newsfeedId.equals(other.newsfeedId) && this.publishedAt.equals(other.publishedAt);
    }

    public int hashCode() {
        return Objects.hash(this.newsfeedId, this.publishedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> newsfeedId = Optional.empty();
        private Optional<Integer> publishedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(NewsfeedAssignment other) {
            this.newsfeedId(other.getNewsfeedId());
            this.publishedAt(other.getPublishedAt());
            return this;
        }

        @JsonSetter(value="newsfeed_id", nulls=Nulls.SKIP)
        public Builder newsfeedId(Optional<Integer> newsfeedId) {
            this.newsfeedId = newsfeedId;
            return this;
        }

        public Builder newsfeedId(Integer newsfeedId) {
            this.newsfeedId = Optional.ofNullable(newsfeedId);
            return this;
        }

        @JsonSetter(value="published_at", nulls=Nulls.SKIP)
        public Builder publishedAt(Optional<Integer> publishedAt) {
            this.publishedAt = publishedAt;
            return this;
        }

        public Builder publishedAt(Integer publishedAt) {
            this.publishedAt = Optional.ofNullable(publishedAt);
            return this;
        }

        public NewsfeedAssignment build() {
            return new NewsfeedAssignment(this.newsfeedId, this.publishedAt, this.additionalProperties);
        }
    }
}

