/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.notes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.admins.types.Admin;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyNote {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<Integer> createdAt;
    private final Optional<Company> company;
    private final Optional<Admin> author;
    private final Optional<String> body;
    private final Map<String, Object> additionalProperties;

    private CompanyNote(Optional<String> type, Optional<String> id, Optional<Integer> createdAt, Optional<Company> company, Optional<Admin> author, Optional<String> body, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.createdAt = createdAt;
        this.company = company;
        this.author = author;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="company")
    public Optional<Company> getCompany() {
        return this.company;
    }

    @JsonProperty(value="author")
    public Optional<Admin> getAuthor() {
        return this.author;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyNote && this.equalTo((CompanyNote)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyNote other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.createdAt.equals(other.createdAt) && this.company.equals(other.company) && this.author.equals(other.author) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.createdAt, this.company, this.author, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Company {
        private final Optional<String> type;
        private final Optional<String> id;
        private final Map<String, Object> additionalProperties;

        private Company(Optional<String> type, Optional<String> id, Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="id")
        public Optional<String> getId() {
            return this.id;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Company && this.equalTo((Company)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Company other) {
            return this.type.equals(other.type) && this.id.equals(other.id);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.id);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<String> id = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Company other) {
                this.type(other.getType());
                this.id(other.getId());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="id", nulls=Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            public Company build() {
                return new Company(this.type, this.id, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Company> company = Optional.empty();
        private Optional<Admin> author = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CompanyNote other) {
            this.type(other.getType());
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.company(other.getCompany());
            this.author(other.getAuthor());
            this.body(other.getBody());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<Company> company) {
            this.company = company;
            return this;
        }

        public Builder company(Company company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @JsonSetter(value="author", nulls=Nulls.SKIP)
        public Builder author(Optional<Admin> author) {
            this.author = author;
            return this;
        }

        public Builder author(Admin author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        public CompanyNote build() {
            return new CompanyNote(this.type, this.id, this.createdAt, this.company, this.author, this.body, this.additionalProperties);
        }
    }
}

