/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.tags;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.tags.AsyncRawTagsClient;
import com.intercom.api.resources.unstable.tags.requests.AttachTagToContactRequest;
import com.intercom.api.resources.unstable.tags.requests.AttachTagToConversationRequest;
import com.intercom.api.resources.unstable.tags.requests.AttachTagToTicketRequest;
import com.intercom.api.resources.unstable.tags.requests.DeleteTagRequest;
import com.intercom.api.resources.unstable.tags.requests.DetachTagFromContactRequest;
import com.intercom.api.resources.unstable.tags.requests.DetachTagFromConversationRequest;
import com.intercom.api.resources.unstable.tags.requests.DetachTagFromTicketRequest;
import com.intercom.api.resources.unstable.tags.requests.FindTagRequest;
import com.intercom.api.resources.unstable.tags.types.CreateTagRequestBody;
import com.intercom.api.resources.unstable.tags.types.Tag;
import com.intercom.api.resources.unstable.types.TagList;
import java.util.concurrent.CompletableFuture;

public class AsyncTagsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTagsClient rawClient;

    public AsyncTagsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTagsClient(clientOptions);
    }

    public AsyncRawTagsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Tag> attachTagToContact(AttachTagToContactRequest request) {
        return this.rawClient.attachTagToContact(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> attachTagToContact(AttachTagToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachTagToContact(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> detachTagFromContact(DetachTagFromContactRequest request) {
        return this.rawClient.detachTagFromContact(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> detachTagFromContact(DetachTagFromContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachTagFromContact(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> attachTagToConversation(AttachTagToConversationRequest request) {
        return this.rawClient.attachTagToConversation(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> attachTagToConversation(AttachTagToConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachTagToConversation(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> detachTagFromConversation(DetachTagFromConversationRequest request) {
        return this.rawClient.detachTagFromConversation(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> detachTagFromConversation(DetachTagFromConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachTagFromConversation(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<TagList> listTags() {
        return this.rawClient.listTags().thenApply(response -> (TagList)response.body());
    }

    public CompletableFuture<TagList> listTags(RequestOptions requestOptions) {
        return this.rawClient.listTags(requestOptions).thenApply(response -> (TagList)response.body());
    }

    public CompletableFuture<Tag> createTag(CreateTagRequestBody request) {
        return this.rawClient.createTag(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> createTag(CreateTagRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createTag(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> findTag(FindTagRequest request) {
        return this.rawClient.findTag(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> findTag(FindTagRequest request, RequestOptions requestOptions) {
        return this.rawClient.findTag(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Void> deleteTag(DeleteTagRequest request) {
        return this.rawClient.deleteTag(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> deleteTag(DeleteTagRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteTag(request, requestOptions).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Tag> attachTagToTicket(AttachTagToTicketRequest request) {
        return this.rawClient.attachTagToTicket(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> attachTagToTicket(AttachTagToTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachTagToTicket(request, requestOptions).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> detachTagFromTicket(DetachTagFromTicketRequest request) {
        return this.rawClient.detachTagFromTicket(request).thenApply(response -> (Tag)response.body());
    }

    public CompletableFuture<Tag> detachTagFromTicket(DetachTagFromTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachTagFromTicket(request, requestOptions).thenApply(response -> (Tag)response.body());
    }
}

