/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.tickets;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.jobs.types.Jobs;
import com.intercom.api.resources.unstable.tickets.AsyncRawTicketsClient;
import com.intercom.api.resources.unstable.tickets.requests.DeleteTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.EnqueueCreateTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.GetTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.ReplyTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.UpdateTicketRequest;
import com.intercom.api.resources.unstable.tickets.types.DeleteTicketResponse;
import com.intercom.api.resources.unstable.tickets.types.Ticket;
import com.intercom.api.resources.unstable.types.SearchRequest;
import com.intercom.api.resources.unstable.types.TicketList;
import com.intercom.api.resources.unstable.types.TicketReply;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncTicketsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTicketsClient rawClient;

    public AsyncTicketsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketsClient(clientOptions);
    }

    public AsyncRawTicketsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TicketReply> replyTicket(ReplyTicketRequest request) {
        return this.rawClient.replyTicket(request).thenApply(response -> (TicketReply)response.body());
    }

    public CompletableFuture<TicketReply> replyTicket(ReplyTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.replyTicket(request, requestOptions).thenApply(response -> (TicketReply)response.body());
    }

    public CompletableFuture<Jobs> enqueueCreateTicket(EnqueueCreateTicketRequest request) {
        return this.rawClient.enqueueCreateTicket(request).thenApply(response -> (Jobs)response.body());
    }

    public CompletableFuture<Jobs> enqueueCreateTicket(EnqueueCreateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.enqueueCreateTicket(request, requestOptions).thenApply(response -> (Jobs)response.body());
    }

    public CompletableFuture<Optional<Ticket>> getTicket(GetTicketRequest request) {
        return this.rawClient.getTicket(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Ticket>> getTicket(GetTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.getTicket(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Ticket>> updateTicket(UpdateTicketRequest request) {
        return this.rawClient.updateTicket(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Ticket>> updateTicket(UpdateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateTicket(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<DeleteTicketResponse> deleteTicket(DeleteTicketRequest request) {
        return this.rawClient.deleteTicket(request).thenApply(response -> (DeleteTicketResponse)response.body());
    }

    public CompletableFuture<DeleteTicketResponse> deleteTicket(DeleteTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteTicket(request, requestOptions).thenApply(response -> (DeleteTicketResponse)response.body());
    }

    public CompletableFuture<TicketList> searchTickets(SearchRequest request) {
        return this.rawClient.searchTickets(request).thenApply(response -> (TicketList)response.body());
    }

    public CompletableFuture<TicketList> searchTickets(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchTickets(request, requestOptions).thenApply(response -> (TicketList)response.body());
    }
}

