/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.tickets.types.TicketContacts;
import com.intercom.api.resources.unstable.tickets.types.TicketState;
import com.intercom.api.resources.unstable.tickets.types.TicketType;
import com.intercom.api.resources.unstable.types.FileAttribute;
import com.intercom.api.resources.unstable.types.LinkedObjectList;
import com.intercom.api.resources.unstable.types.TicketParts;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Ticket {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> ticketId;
    private final Optional<Category> category;
    private final Optional<Map<String, TicketAttributesValue>> ticketAttributes;
    private final Optional<TicketState> ticketState;
    private final Optional<TicketType> ticketType;
    private final Optional<TicketContacts> contacts;
    private final Optional<String> adminAssigneeId;
    private final Optional<String> teamAssigneeId;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<Boolean> open;
    private final Optional<Integer> snoozedUntil;
    private final Optional<LinkedObjectList> linkedObjects;
    private final Optional<TicketParts> ticketParts;
    private final Optional<Boolean> isShared;
    private final Map<String, Object> additionalProperties;

    private Ticket(Optional<String> type, Optional<String> id, Optional<String> ticketId, Optional<Category> category, Optional<Map<String, TicketAttributesValue>> ticketAttributes, Optional<TicketState> ticketState, Optional<TicketType> ticketType, Optional<TicketContacts> contacts, Optional<String> adminAssigneeId, Optional<String> teamAssigneeId, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<Boolean> open, Optional<Integer> snoozedUntil, Optional<LinkedObjectList> linkedObjects, Optional<TicketParts> ticketParts, Optional<Boolean> isShared, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.ticketId = ticketId;
        this.category = category;
        this.ticketAttributes = ticketAttributes;
        this.ticketState = ticketState;
        this.ticketType = ticketType;
        this.contacts = contacts;
        this.adminAssigneeId = adminAssigneeId;
        this.teamAssigneeId = teamAssigneeId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.open = open;
        this.snoozedUntil = snoozedUntil;
        this.linkedObjects = linkedObjects;
        this.ticketParts = ticketParts;
        this.isShared = isShared;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="ticket_id")
    public Optional<String> getTicketId() {
        return this.ticketId;
    }

    @JsonProperty(value="category")
    public Optional<Category> getCategory() {
        return this.category;
    }

    @JsonProperty(value="ticket_attributes")
    public Optional<Map<String, TicketAttributesValue>> getTicketAttributes() {
        return this.ticketAttributes;
    }

    @JsonProperty(value="ticket_state")
    public Optional<TicketState> getTicketState() {
        return this.ticketState;
    }

    @JsonProperty(value="ticket_type")
    public Optional<TicketType> getTicketType() {
        return this.ticketType;
    }

    @JsonProperty(value="contacts")
    public Optional<TicketContacts> getContacts() {
        return this.contacts;
    }

    @JsonProperty(value="admin_assignee_id")
    public Optional<String> getAdminAssigneeId() {
        return this.adminAssigneeId;
    }

    @JsonProperty(value="team_assignee_id")
    public Optional<String> getTeamAssigneeId() {
        return this.teamAssigneeId;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="open")
    public Optional<Boolean> getOpen() {
        return this.open;
    }

    @JsonProperty(value="snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return this.snoozedUntil;
    }

    @JsonProperty(value="linked_objects")
    public Optional<LinkedObjectList> getLinkedObjects() {
        return this.linkedObjects;
    }

    @JsonProperty(value="ticket_parts")
    public Optional<TicketParts> getTicketParts() {
        return this.ticketParts;
    }

    @JsonProperty(value="is_shared")
    public Optional<Boolean> getIsShared() {
        return this.isShared;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Ticket && this.equalTo((Ticket)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Ticket other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.ticketId.equals(other.ticketId) && this.category.equals(other.category) && this.ticketAttributes.equals(other.ticketAttributes) && this.ticketState.equals(other.ticketState) && this.ticketType.equals(other.ticketType) && this.contacts.equals(other.contacts) && this.adminAssigneeId.equals(other.adminAssigneeId) && this.teamAssigneeId.equals(other.teamAssigneeId) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.open.equals(other.open) && this.snoozedUntil.equals(other.snoozedUntil) && this.linkedObjects.equals(other.linkedObjects) && this.ticketParts.equals(other.ticketParts) && this.isShared.equals(other.isShared);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.ticketId, this.category, this.ticketAttributes, this.ticketState, this.ticketType, this.contacts, this.adminAssigneeId, this.teamAssigneeId, this.createdAt, this.updatedAt, this.open, this.snoozedUntil, this.linkedObjects, this.ticketParts, this.isShared);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class TicketAttributesValue {
        private final Object value;
        private final int type;

        private TicketAttributesValue(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((Optional)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((Double)this.value);
            }
            if (this.type == 2) {
                return visitor.visit((Boolean)this.value);
            }
            if (this.type == 3) {
                return visitor.visit((List)this.value);
            }
            if (this.type == 4) {
                return visitor.visit((FileAttribute)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TicketAttributesValue && this.equalTo((TicketAttributesValue)other);
        }

        private boolean equalTo(TicketAttributesValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static TicketAttributesValue of(Optional<String> value) {
            return new TicketAttributesValue(value, 0);
        }

        public static TicketAttributesValue of(double value) {
            return new TicketAttributesValue(value, 1);
        }

        public static TicketAttributesValue of(boolean value) {
            return new TicketAttributesValue(value, 2);
        }

        public static TicketAttributesValue of(List<Object> value) {
            return new TicketAttributesValue(value, 3);
        }

        public static TicketAttributesValue of(FileAttribute value) {
            return new TicketAttributesValue(value, 4);
        }

        static final class Deserializer
        extends StdDeserializer<TicketAttributesValue> {
            Deserializer() {
                super(TicketAttributesValue.class);
            }

            public TicketAttributesValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return TicketAttributesValue.of((Optional)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Optional<String>>(){}));
                }
                catch (RuntimeException runtimeException) {
                    if (value instanceof Double) {
                        return TicketAttributesValue.of((Double)value);
                    }
                    if (value instanceof Boolean) {
                        return TicketAttributesValue.of((Boolean)value);
                    }
                    try {
                        return TicketAttributesValue.of((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<Object>>(){}));
                    }
                    catch (RuntimeException runtimeException2) {
                        try {
                            return TicketAttributesValue.of((FileAttribute)ObjectMappers.JSON_MAPPER.convertValue(value, FileAttribute.class));
                        }
                        catch (RuntimeException runtimeException3) {
                            throw new JsonParseException(p, "Failed to deserialize");
                        }
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(Optional<String> var1);

            public T visit(double var1);

            public T visit(boolean var1);

            public T visit(List<Object> var1);

            public T visit(FileAttribute var1);
        }
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");
        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");
        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");
        private final Value value;
        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Category && this.string.equals(((Category)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case BACK_OFFICE: {
                    return visitor.visitBackOffice();
                }
                case CUSTOMER: {
                    return visitor.visitCustomer();
                }
                case TRACKER: {
                    return visitor.visitTracker();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office": {
                    return BACK_OFFICE;
                }
                case "Customer": {
                    return CUSTOMER;
                }
                case "Tracker": {
                    return TRACKER;
                }
            }
            return new Category(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitCustomer();

            public T visitBackOffice();

            public T visitTracker();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CUSTOMER,
            BACK_OFFICE,
            TRACKER,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> ticketId = Optional.empty();
        private Optional<Category> category = Optional.empty();
        private Optional<Map<String, TicketAttributesValue>> ticketAttributes = Optional.empty();
        private Optional<TicketState> ticketState = Optional.empty();
        private Optional<TicketType> ticketType = Optional.empty();
        private Optional<TicketContacts> contacts = Optional.empty();
        private Optional<String> adminAssigneeId = Optional.empty();
        private Optional<String> teamAssigneeId = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<Boolean> open = Optional.empty();
        private Optional<Integer> snoozedUntil = Optional.empty();
        private Optional<LinkedObjectList> linkedObjects = Optional.empty();
        private Optional<TicketParts> ticketParts = Optional.empty();
        private Optional<Boolean> isShared = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Ticket other) {
            this.type(other.getType());
            this.id(other.getId());
            this.ticketId(other.getTicketId());
            this.category(other.getCategory());
            this.ticketAttributes(other.getTicketAttributes());
            this.ticketState(other.getTicketState());
            this.ticketType(other.getTicketType());
            this.contacts(other.getContacts());
            this.adminAssigneeId(other.getAdminAssigneeId());
            this.teamAssigneeId(other.getTeamAssigneeId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.open(other.getOpen());
            this.snoozedUntil(other.getSnoozedUntil());
            this.linkedObjects(other.getLinkedObjects());
            this.ticketParts(other.getTicketParts());
            this.isShared(other.getIsShared());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="ticket_id", nulls=Nulls.SKIP)
        public Builder ticketId(Optional<String> ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public Builder ticketId(String ticketId) {
            this.ticketId = Optional.ofNullable(ticketId);
            return this;
        }

        @JsonSetter(value="category", nulls=Nulls.SKIP)
        public Builder category(Optional<Category> category) {
            this.category = category;
            return this;
        }

        public Builder category(Category category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        @JsonSetter(value="ticket_attributes", nulls=Nulls.SKIP)
        public Builder ticketAttributes(Optional<Map<String, TicketAttributesValue>> ticketAttributes) {
            this.ticketAttributes = ticketAttributes;
            return this;
        }

        public Builder ticketAttributes(Map<String, TicketAttributesValue> ticketAttributes) {
            this.ticketAttributes = Optional.ofNullable(ticketAttributes);
            return this;
        }

        @JsonSetter(value="ticket_state", nulls=Nulls.SKIP)
        public Builder ticketState(Optional<TicketState> ticketState) {
            this.ticketState = ticketState;
            return this;
        }

        public Builder ticketState(TicketState ticketState) {
            this.ticketState = Optional.ofNullable(ticketState);
            return this;
        }

        @JsonSetter(value="ticket_type", nulls=Nulls.SKIP)
        public Builder ticketType(Optional<TicketType> ticketType) {
            this.ticketType = ticketType;
            return this;
        }

        public Builder ticketType(TicketType ticketType) {
            this.ticketType = Optional.ofNullable(ticketType);
            return this;
        }

        @JsonSetter(value="contacts", nulls=Nulls.SKIP)
        public Builder contacts(Optional<TicketContacts> contacts) {
            this.contacts = contacts;
            return this;
        }

        public Builder contacts(TicketContacts contacts) {
            this.contacts = Optional.ofNullable(contacts);
            return this;
        }

        @JsonSetter(value="admin_assignee_id", nulls=Nulls.SKIP)
        public Builder adminAssigneeId(Optional<String> adminAssigneeId) {
            this.adminAssigneeId = adminAssigneeId;
            return this;
        }

        public Builder adminAssigneeId(String adminAssigneeId) {
            this.adminAssigneeId = Optional.ofNullable(adminAssigneeId);
            return this;
        }

        @JsonSetter(value="team_assignee_id", nulls=Nulls.SKIP)
        public Builder teamAssigneeId(Optional<String> teamAssigneeId) {
            this.teamAssigneeId = teamAssigneeId;
            return this;
        }

        public Builder teamAssigneeId(String teamAssigneeId) {
            this.teamAssigneeId = Optional.ofNullable(teamAssigneeId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="open", nulls=Nulls.SKIP)
        public Builder open(Optional<Boolean> open) {
            this.open = open;
            return this;
        }

        public Builder open(Boolean open) {
            this.open = Optional.ofNullable(open);
            return this;
        }

        @JsonSetter(value="snoozed_until", nulls=Nulls.SKIP)
        public Builder snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        public Builder snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        @JsonSetter(value="linked_objects", nulls=Nulls.SKIP)
        public Builder linkedObjects(Optional<LinkedObjectList> linkedObjects) {
            this.linkedObjects = linkedObjects;
            return this;
        }

        public Builder linkedObjects(LinkedObjectList linkedObjects) {
            this.linkedObjects = Optional.ofNullable(linkedObjects);
            return this;
        }

        @JsonSetter(value="ticket_parts", nulls=Nulls.SKIP)
        public Builder ticketParts(Optional<TicketParts> ticketParts) {
            this.ticketParts = ticketParts;
            return this;
        }

        public Builder ticketParts(TicketParts ticketParts) {
            this.ticketParts = Optional.ofNullable(ticketParts);
            return this;
        }

        @JsonSetter(value="is_shared", nulls=Nulls.SKIP)
        public Builder isShared(Optional<Boolean> isShared) {
            this.isShared = isShared;
            return this;
        }

        public Builder isShared(Boolean isShared) {
            this.isShared = Optional.ofNullable(isShared);
            return this;
        }

        public Ticket build() {
            return new Ticket(this.type, this.id, this.ticketId, this.category, this.ticketAttributes, this.ticketState, this.ticketType, this.contacts, this.adminAssigneeId, this.teamAssigneeId, this.createdAt, this.updatedAt, this.open, this.snoozedUntil, this.linkedObjects, this.ticketParts, this.isShared, this.additionalProperties);
        }
    }
}

