/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.ticketstates;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.ticketstates.AsyncRawTicketStatesClient;
import com.intercom.api.resources.unstable.types.TicketStateList;
import java.util.concurrent.CompletableFuture;

public class AsyncTicketStatesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTicketStatesClient rawClient;

    public AsyncTicketStatesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketStatesClient(clientOptions);
    }

    public AsyncRawTicketStatesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TicketStateList> listTicketStates() {
        return this.rawClient.listTicketStates().thenApply(response -> (TicketStateList)response.body());
    }

    public CompletableFuture<TicketStateList> listTicketStates(RequestOptions requestOptions) {
        return this.rawClient.listTicketStates(requestOptions).thenApply(response -> (TicketStateList)response.body());
    }
}

