/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.CompanyData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactCompanies {
    private final Optional<List<CompanyData>> data;
    private final Optional<String> url;
    private final Optional<Integer> totalCount;
    private final Optional<Boolean> hasMore;
    private final Map<String, Object> additionalProperties;

    private ContactCompanies(Optional<List<CompanyData>> data, Optional<String> url, Optional<Integer> totalCount, Optional<Boolean> hasMore, Map<String, Object> additionalProperties) {
        this.data = data;
        this.url = url;
        this.totalCount = totalCount;
        this.hasMore = hasMore;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="data")
    public Optional<List<CompanyData>> getData() {
        return this.data;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="total_count")
    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="has_more")
    public Optional<Boolean> getHasMore() {
        return this.hasMore;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactCompanies && this.equalTo((ContactCompanies)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactCompanies other) {
        return this.data.equals(other.data) && this.url.equals(other.url) && this.totalCount.equals(other.totalCount) && this.hasMore.equals(other.hasMore);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.url, this.totalCount, this.hasMore);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<CompanyData>> data = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<Integer> totalCount = Optional.empty();
        private Optional<Boolean> hasMore = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContactCompanies other) {
            this.data(other.getData());
            this.url(other.getUrl());
            this.totalCount(other.getTotalCount());
            this.hasMore(other.getHasMore());
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<List<CompanyData>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<CompanyData> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value="has_more", nulls=Nulls.SKIP)
        public Builder hasMore(Optional<Boolean> hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        public Builder hasMore(Boolean hasMore) {
            this.hasMore = Optional.ofNullable(hasMore);
            return this;
        }

        public ContactCompanies build() {
            return new ContactCompanies(this.data, this.url, this.totalCount, this.hasMore, this.additionalProperties);
        }
    }
}

