/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.IContactReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactDeleted
implements IContactReference {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> externalId;
    private final Optional<Boolean> deleted;
    private final Map<String, Object> additionalProperties;

    private ContactDeleted(Optional<String> type, Optional<String> id, Optional<String> externalId, Optional<Boolean> deleted, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.externalId = externalId;
        this.deleted = deleted;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="deleted")
    public Optional<Boolean> getDeleted() {
        return this.deleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactDeleted && this.equalTo((ContactDeleted)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactDeleted other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.externalId.equals(other.externalId) && this.deleted.equals(other.deleted);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.externalId, this.deleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<Boolean> deleted = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContactDeleted other) {
            this.type(other.getType());
            this.id(other.getId());
            this.externalId(other.getExternalId());
            this.deleted(other.getDeleted());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public Builder externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @JsonSetter(value="deleted", nulls=Nulls.SKIP)
        public Builder deleted(Optional<Boolean> deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder deleted(Boolean deleted) {
            this.deleted = Optional.ofNullable(deleted);
            return this;
        }

        public ContactDeleted build() {
            return new ContactDeleted(this.type, this.id, this.externalId, this.deleted, this.additionalProperties);
        }
    }
}

