/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationSlaPaused {
    private final Optional<String> slaName;
    private final Optional<CurrentSlaStatus> currentSlaStatus;
    private final Optional<Map<String, SlaStatesValue>> slaStates;
    private final Map<String, Object> additionalProperties;

    private ConversationSlaPaused(Optional<String> slaName, Optional<CurrentSlaStatus> currentSlaStatus, Optional<Map<String, SlaStatesValue>> slaStates, Map<String, Object> additionalProperties) {
        this.slaName = slaName;
        this.currentSlaStatus = currentSlaStatus;
        this.slaStates = slaStates;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="sla_name")
    public Optional<String> getSlaName() {
        return this.slaName;
    }

    @JsonProperty(value="current_sla_status")
    public Optional<CurrentSlaStatus> getCurrentSlaStatus() {
        return this.currentSlaStatus;
    }

    @JsonProperty(value="sla_states")
    public Optional<Map<String, SlaStatesValue>> getSlaStates() {
        return this.slaStates;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationSlaPaused && this.equalTo((ConversationSlaPaused)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationSlaPaused other) {
        return this.slaName.equals(other.slaName) && this.currentSlaStatus.equals(other.currentSlaStatus) && this.slaStates.equals(other.slaStates);
    }

    public int hashCode() {
        return Objects.hash(this.slaName, this.currentSlaStatus, this.slaStates);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class SlaStatesValue {
        private final Optional<String> status;
        private final Optional<Integer> secondsRemaining;
        private final Map<String, Object> additionalProperties;

        private SlaStatesValue(Optional<String> status, Optional<Integer> secondsRemaining, Map<String, Object> additionalProperties) {
            this.status = status;
            this.secondsRemaining = secondsRemaining;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="status")
        public Optional<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="seconds_remaining")
        public Optional<Integer> getSecondsRemaining() {
            return this.secondsRemaining;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SlaStatesValue && this.equalTo((SlaStatesValue)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(SlaStatesValue other) {
            return this.status.equals(other.status) && this.secondsRemaining.equals(other.secondsRemaining);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.secondsRemaining);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> status = Optional.empty();
            private Optional<Integer> secondsRemaining = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(SlaStatesValue other) {
                this.status(other.getStatus());
                this.secondsRemaining(other.getSecondsRemaining());
                return this;
            }

            @JsonSetter(value="status", nulls=Nulls.SKIP)
            public Builder status(Optional<String> status) {
                this.status = status;
                return this;
            }

            public Builder status(String status) {
                this.status = Optional.ofNullable(status);
                return this;
            }

            @JsonSetter(value="seconds_remaining", nulls=Nulls.SKIP)
            public Builder secondsRemaining(Optional<Integer> secondsRemaining) {
                this.secondsRemaining = secondsRemaining;
                return this;
            }

            public Builder secondsRemaining(Integer secondsRemaining) {
                this.secondsRemaining = Optional.ofNullable(secondsRemaining);
                return this;
            }

            public SlaStatesValue build() {
                return new SlaStatesValue(this.status, this.secondsRemaining, this.additionalProperties);
            }
        }
    }

    public static final class CurrentSlaStatus {
        public static final CurrentSlaStatus HIT = new CurrentSlaStatus(Value.HIT, "hit");
        public static final CurrentSlaStatus CANCELED = new CurrentSlaStatus(Value.CANCELED, "canceled");
        public static final CurrentSlaStatus ACTIVE = new CurrentSlaStatus(Value.ACTIVE, "active");
        public static final CurrentSlaStatus MISSED = new CurrentSlaStatus(Value.MISSED, "missed");
        private final Value value;
        private final String string;

        CurrentSlaStatus(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof CurrentSlaStatus && this.string.equals(((CurrentSlaStatus)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case HIT: {
                    return visitor.visitHit();
                }
                case CANCELED: {
                    return visitor.visitCanceled();
                }
                case ACTIVE: {
                    return visitor.visitActive();
                }
                case MISSED: {
                    return visitor.visitMissed();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static CurrentSlaStatus valueOf(String value) {
            switch (value) {
                case "hit": {
                    return HIT;
                }
                case "canceled": {
                    return CANCELED;
                }
                case "active": {
                    return ACTIVE;
                }
                case "missed": {
                    return MISSED;
                }
            }
            return new CurrentSlaStatus(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitActive();

            public T visitHit();

            public T visitMissed();

            public T visitCanceled();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ACTIVE,
            HIT,
            MISSED,
            CANCELED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> slaName = Optional.empty();
        private Optional<CurrentSlaStatus> currentSlaStatus = Optional.empty();
        private Optional<Map<String, SlaStatesValue>> slaStates = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationSlaPaused other) {
            this.slaName(other.getSlaName());
            this.currentSlaStatus(other.getCurrentSlaStatus());
            this.slaStates(other.getSlaStates());
            return this;
        }

        @JsonSetter(value="sla_name", nulls=Nulls.SKIP)
        public Builder slaName(Optional<String> slaName) {
            this.slaName = slaName;
            return this;
        }

        public Builder slaName(String slaName) {
            this.slaName = Optional.ofNullable(slaName);
            return this;
        }

        @JsonSetter(value="current_sla_status", nulls=Nulls.SKIP)
        public Builder currentSlaStatus(Optional<CurrentSlaStatus> currentSlaStatus) {
            this.currentSlaStatus = currentSlaStatus;
            return this;
        }

        public Builder currentSlaStatus(CurrentSlaStatus currentSlaStatus) {
            this.currentSlaStatus = Optional.ofNullable(currentSlaStatus);
            return this;
        }

        @JsonSetter(value="sla_states", nulls=Nulls.SKIP)
        public Builder slaStates(Optional<Map<String, SlaStatesValue>> slaStates) {
            this.slaStates = slaStates;
            return this;
        }

        public Builder slaStates(Map<String, SlaStatesValue> slaStates) {
            this.slaStates = Optional.ofNullable(slaStates);
            return this;
        }

        public ConversationSlaPaused build() {
            return new ConversationSlaPaused(this.slaName, this.currentSlaStatus, this.slaStates, this.additionalProperties);
        }
    }
}

