/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ICreateTicketRequestBody;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateTicketRequestBody
implements ICreateTicketRequestBody {
    private final String ticketTypeId;
    private final List<ContactsItem> contacts;
    private final Optional<String> conversationToLinkId;
    private final Optional<String> companyId;
    private final Optional<Integer> createdAt;
    private final Optional<Assignment> assignment;
    private final Map<String, Object> additionalProperties;

    private CreateTicketRequestBody(String ticketTypeId, List<ContactsItem> contacts, Optional<String> conversationToLinkId, Optional<String> companyId, Optional<Integer> createdAt, Optional<Assignment> assignment, Map<String, Object> additionalProperties) {
        this.ticketTypeId = ticketTypeId;
        this.contacts = contacts;
        this.conversationToLinkId = conversationToLinkId;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.assignment = assignment;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="ticket_type_id")
    public String getTicketTypeId() {
        return this.ticketTypeId;
    }

    @JsonProperty(value="contacts")
    public List<ContactsItem> getContacts() {
        return this.contacts;
    }

    @Override
    @JsonProperty(value="conversation_to_link_id")
    public Optional<String> getConversationToLinkId() {
        return this.conversationToLinkId;
    }

    @Override
    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @Override
    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="assignment")
    public Optional<Assignment> getAssignment() {
        return this.assignment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTicketRequestBody && this.equalTo((CreateTicketRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTicketRequestBody other) {
        return this.ticketTypeId.equals(other.ticketTypeId) && this.contacts.equals(other.contacts) && this.conversationToLinkId.equals(other.conversationToLinkId) && this.companyId.equals(other.companyId) && this.createdAt.equals(other.createdAt) && this.assignment.equals(other.assignment);
    }

    public int hashCode() {
        return Objects.hash(this.ticketTypeId, this.contacts, this.conversationToLinkId, this.companyId, this.createdAt, this.assignment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketTypeIdStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Assignment {
        private final Optional<String> adminAssigneeId;
        private final Optional<String> teamAssigneeId;
        private final Map<String, Object> additionalProperties;

        private Assignment(Optional<String> adminAssigneeId, Optional<String> teamAssigneeId, Map<String, Object> additionalProperties) {
            this.adminAssigneeId = adminAssigneeId;
            this.teamAssigneeId = teamAssigneeId;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="admin_assignee_id")
        public Optional<String> getAdminAssigneeId() {
            return this.adminAssigneeId;
        }

        @JsonProperty(value="team_assignee_id")
        public Optional<String> getTeamAssigneeId() {
            return this.teamAssigneeId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Assignment && this.equalTo((Assignment)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Assignment other) {
            return this.adminAssigneeId.equals(other.adminAssigneeId) && this.teamAssigneeId.equals(other.teamAssigneeId);
        }

        public int hashCode() {
            return Objects.hash(this.adminAssigneeId, this.teamAssigneeId);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> adminAssigneeId = Optional.empty();
            private Optional<String> teamAssigneeId = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Assignment other) {
                this.adminAssigneeId(other.getAdminAssigneeId());
                this.teamAssigneeId(other.getTeamAssigneeId());
                return this;
            }

            @JsonSetter(value="admin_assignee_id", nulls=Nulls.SKIP)
            public Builder adminAssigneeId(Optional<String> adminAssigneeId) {
                this.adminAssigneeId = adminAssigneeId;
                return this;
            }

            public Builder adminAssigneeId(String adminAssigneeId) {
                this.adminAssigneeId = Optional.ofNullable(adminAssigneeId);
                return this;
            }

            @JsonSetter(value="team_assignee_id", nulls=Nulls.SKIP)
            public Builder teamAssigneeId(Optional<String> teamAssigneeId) {
                this.teamAssigneeId = teamAssigneeId;
                return this;
            }

            public Builder teamAssigneeId(String teamAssigneeId) {
                this.teamAssigneeId = Optional.ofNullable(teamAssigneeId);
                return this;
            }

            public Assignment build() {
                return new Assignment(this.adminAssigneeId, this.teamAssigneeId, this.additionalProperties);
            }
        }
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class ContactsItem {
        private final Object value;
        private final int type;

        private ContactsItem(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((Id)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((ExternalId)this.value);
            }
            if (this.type == 2) {
                return visitor.visit((Email)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ContactsItem && this.equalTo((ContactsItem)other);
        }

        private boolean equalTo(ContactsItem other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static ContactsItem of(Id value) {
            return new ContactsItem(value, 0);
        }

        public static ContactsItem of(ExternalId value) {
            return new ContactsItem(value, 1);
        }

        public static ContactsItem of(Email value) {
            return new ContactsItem(value, 2);
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class Email {
            private final String email;
            private final Map<String, Object> additionalProperties;

            private Email(String email, Map<String, Object> additionalProperties) {
                this.email = email;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="email")
            public String getEmail() {
                return this.email;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof Email && this.equalTo((Email)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Email other) {
                return this.email.equals(other.email);
            }

            public int hashCode() {
                return Objects.hash(this.email);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static EmailStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements EmailStage,
            _FinalStage {
                private String email;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(Email other) {
                    this.email(other.getEmail());
                    return this;
                }

                @Override
                @JsonSetter(value="email")
                public _FinalStage email(@NotNull String email) {
                    this.email = Objects.requireNonNull(email, "email must not be null");
                    return this;
                }

                @Override
                public Email build() {
                    return new Email(this.email, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public Email build();
            }

            public static interface EmailStage {
                public _FinalStage email(@NotNull String var1);

                public Builder from(Email var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class ExternalId {
            private final String externalId;
            private final Map<String, Object> additionalProperties;

            private ExternalId(String externalId, Map<String, Object> additionalProperties) {
                this.externalId = externalId;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="external_id")
            public String getExternalId() {
                return this.externalId;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof ExternalId && this.equalTo((ExternalId)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(ExternalId other) {
                return this.externalId.equals(other.externalId);
            }

            public int hashCode() {
                return Objects.hash(this.externalId);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static ExternalIdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements ExternalIdStage,
            _FinalStage {
                private String externalId;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(ExternalId other) {
                    this.externalId(other.getExternalId());
                    return this;
                }

                @Override
                @JsonSetter(value="external_id")
                public _FinalStage externalId(@NotNull String externalId) {
                    this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
                    return this;
                }

                @Override
                public ExternalId build() {
                    return new ExternalId(this.externalId, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public ExternalId build();
            }

            public static interface ExternalIdStage {
                public _FinalStage externalId(@NotNull String var1);

                public Builder from(ExternalId var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class Id {
            private final String id;
            private final Map<String, Object> additionalProperties;

            private Id(String id, Map<String, Object> additionalProperties) {
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="id")
            public String getId() {
                return this.id;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof Id && this.equalTo((Id)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Id other) {
                return this.id.equals(other.id);
            }

            public int hashCode() {
                return Objects.hash(this.id);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements IdStage,
            _FinalStage {
                private String id;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(Id other) {
                    this.id(other.getId());
                    return this;
                }

                @Override
                @JsonSetter(value="id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @Override
                public Id build() {
                    return new Id(this.id, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public Id build();
            }

            public static interface IdStage {
                public _FinalStage id(@NotNull String var1);

                public Builder from(Id var1);
            }
        }

        static final class Deserializer
        extends StdDeserializer<ContactsItem> {
            Deserializer() {
                super(ContactsItem.class);
            }

            public ContactsItem deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return ContactsItem.of((Id)ObjectMappers.JSON_MAPPER.convertValue(value, Id.class));
                }
                catch (RuntimeException runtimeException) {
                    try {
                        return ContactsItem.of((ExternalId)ObjectMappers.JSON_MAPPER.convertValue(value, ExternalId.class));
                    }
                    catch (RuntimeException runtimeException2) {
                        try {
                            return ContactsItem.of((Email)ObjectMappers.JSON_MAPPER.convertValue(value, Email.class));
                        }
                        catch (RuntimeException runtimeException3) {
                            throw new JsonParseException(p, "Failed to deserialize");
                        }
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(Id var1);

            public T visit(ExternalId var1);

            public T visit(Email var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TicketTypeIdStage,
    _FinalStage {
        private String ticketTypeId;
        private Optional<Assignment> assignment = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<String> conversationToLinkId = Optional.empty();
        private List<ContactsItem> contacts = new ArrayList<ContactsItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateTicketRequestBody other) {
            this.ticketTypeId(other.getTicketTypeId());
            this.contacts(other.getContacts());
            this.conversationToLinkId(other.getConversationToLinkId());
            this.companyId(other.getCompanyId());
            this.createdAt(other.getCreatedAt());
            this.assignment(other.getAssignment());
            return this;
        }

        @Override
        @JsonSetter(value="ticket_type_id")
        public _FinalStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @Override
        public _FinalStage assignment(Assignment assignment) {
            this.assignment = Optional.ofNullable(assignment);
            return this;
        }

        @Override
        @JsonSetter(value="assignment", nulls=Nulls.SKIP)
        public _FinalStage assignment(Optional<Assignment> assignment) {
            this.assignment = assignment;
            return this;
        }

        @Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public _FinalStage conversationToLinkId(String conversationToLinkId) {
            this.conversationToLinkId = Optional.ofNullable(conversationToLinkId);
            return this;
        }

        @Override
        @JsonSetter(value="conversation_to_link_id", nulls=Nulls.SKIP)
        public _FinalStage conversationToLinkId(Optional<String> conversationToLinkId) {
            this.conversationToLinkId = conversationToLinkId;
            return this;
        }

        @Override
        public _FinalStage addAllContacts(List<ContactsItem> contacts) {
            if (contacts != null) {
                this.contacts.addAll(contacts);
            }
            return this;
        }

        @Override
        public _FinalStage addContacts(ContactsItem contacts) {
            this.contacts.add(contacts);
            return this;
        }

        @Override
        @JsonSetter(value="contacts", nulls=Nulls.SKIP)
        public _FinalStage contacts(List<ContactsItem> contacts) {
            this.contacts.clear();
            if (contacts != null) {
                this.contacts.addAll(contacts);
            }
            return this;
        }

        @Override
        public CreateTicketRequestBody build() {
            return new CreateTicketRequestBody(this.ticketTypeId, this.contacts, this.conversationToLinkId, this.companyId, this.createdAt, this.assignment, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateTicketRequestBody build();

        public _FinalStage contacts(List<ContactsItem> var1);

        public _FinalStage addContacts(ContactsItem var1);

        public _FinalStage addAllContacts(List<ContactsItem> var1);

        public _FinalStage conversationToLinkId(Optional<String> var1);

        public _FinalStage conversationToLinkId(String var1);

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage createdAt(Optional<Integer> var1);

        public _FinalStage createdAt(Integer var1);

        public _FinalStage assignment(Optional<Assignment> var1);

        public _FinalStage assignment(Assignment var1);
    }

    public static interface TicketTypeIdStage {
        public _FinalStage ticketTypeId(@NotNull String var1);

        public Builder from(CreateTicketRequestBody var1);
    }
}

