/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomObjectInstanceDeleted {
    private final Optional<String> object;
    private final Optional<String> id;
    private final Optional<Boolean> deleted;
    private final Map<String, Object> additionalProperties;

    private CustomObjectInstanceDeleted(Optional<String> object, Optional<String> id, Optional<Boolean> deleted, Map<String, Object> additionalProperties) {
        this.object = object;
        this.id = id;
        this.deleted = deleted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="object")
    public Optional<String> getObject() {
        return this.object;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="deleted")
    public Optional<Boolean> getDeleted() {
        return this.deleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomObjectInstanceDeleted && this.equalTo((CustomObjectInstanceDeleted)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomObjectInstanceDeleted other) {
        return this.object.equals(other.object) && this.id.equals(other.id) && this.deleted.equals(other.deleted);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.id, this.deleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> object = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<Boolean> deleted = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomObjectInstanceDeleted other) {
            this.object(other.getObject());
            this.id(other.getId());
            this.deleted(other.getDeleted());
            return this;
        }

        @JsonSetter(value="object", nulls=Nulls.SKIP)
        public Builder object(Optional<String> object) {
            this.object = object;
            return this;
        }

        public Builder object(String object) {
            this.object = Optional.ofNullable(object);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="deleted", nulls=Nulls.SKIP)
        public Builder deleted(Optional<Boolean> deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder deleted(Boolean deleted) {
            this.deleted = Optional.ofNullable(deleted);
            return this;
        }

        public CustomObjectInstanceDeleted build() {
            return new CustomObjectInstanceDeleted(this.object, this.id, this.deleted, this.additionalProperties);
        }
    }
}

