/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class Datetime {
    private final Object value;
    private final int type;

    private Datetime(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((OffsetDateTime)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((Integer)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Datetime && this.equalTo((Datetime)other);
    }

    private boolean equalTo(Datetime other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static Datetime of(OffsetDateTime value) {
        return new Datetime(value, 0);
    }

    public static Datetime of(int value) {
        return new Datetime(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<Datetime> {
        Deserializer() {
            super(Datetime.class);
        }

        public Datetime deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return Datetime.of((OffsetDateTime)ObjectMappers.JSON_MAPPER.convertValue(value, OffsetDateTime.class));
            }
            catch (RuntimeException runtimeException) {
                if (value instanceof Integer) {
                    return Datetime.of((Integer)value);
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(OffsetDateTime var1);

        public T visit(int var1);
    }
}

