/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.TeammateReference;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class HandlingEvent {
    private final TeammateReference teammate;
    private final Type type;
    private final OffsetDateTime timestamp;
    private final Optional<String> reason;
    private final Map<String, Object> additionalProperties;

    private HandlingEvent(TeammateReference teammate, Type type, OffsetDateTime timestamp, Optional<String> reason, Map<String, Object> additionalProperties) {
        this.teammate = teammate;
        this.type = type;
        this.timestamp = timestamp;
        this.reason = reason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="teammate")
    public TeammateReference getTeammate() {
        return this.teammate;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="reason")
    public Optional<String> getReason() {
        return this.reason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof HandlingEvent && this.equalTo((HandlingEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HandlingEvent other) {
        return this.teammate.equals(other.teammate) && this.type.equals(other.type) && this.timestamp.equals(other.timestamp) && this.reason.equals(other.reason);
    }

    public int hashCode() {
        return Objects.hash(this.teammate, this.type, this.timestamp, this.reason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TeammateStage builder() {
        return new Builder();
    }

    public static final class Type {
        public static final Type RESUMED = new Type(Value.RESUMED, "resumed");
        public static final Type PAUSED = new Type(Value.PAUSED, "paused");
        private final Value value;
        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Type && this.string.equals(((Type)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case RESUMED: {
                    return visitor.visitResumed();
                }
                case PAUSED: {
                    return visitor.visitPaused();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "resumed": {
                    return RESUMED;
                }
                case "paused": {
                    return PAUSED;
                }
            }
            return new Type(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPaused();

            public T visitResumed();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PAUSED,
            RESUMED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TeammateStage,
    TypeStage,
    TimestampStage,
    _FinalStage {
        private TeammateReference teammate;
        private Type type;
        private OffsetDateTime timestamp;
        private Optional<String> reason = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(HandlingEvent other) {
            this.teammate(other.getTeammate());
            this.type(other.getType());
            this.timestamp(other.getTimestamp());
            this.reason(other.getReason());
            return this;
        }

        @Override
        @JsonSetter(value="teammate")
        public TypeStage teammate(@NotNull TeammateReference teammate) {
            this.teammate = Objects.requireNonNull(teammate, "teammate must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public TimestampStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public _FinalStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        public _FinalStage reason(String reason) {
            this.reason = Optional.ofNullable(reason);
            return this;
        }

        @Override
        @JsonSetter(value="reason", nulls=Nulls.SKIP)
        public _FinalStage reason(Optional<String> reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public HandlingEvent build() {
            return new HandlingEvent(this.teammate, this.type, this.timestamp, this.reason, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public HandlingEvent build();

        public _FinalStage reason(Optional<String> var1);

        public _FinalStage reason(String var1);
    }

    public static interface TimestampStage {
        public _FinalStage timestamp(@NotNull OffsetDateTime var1);
    }

    public static interface TypeStage {
        public TimestampStage type(@NotNull Type var1);
    }

    public static interface TeammateStage {
        public TypeStage teammate(@NotNull TeammateReference var1);

        public Builder from(HandlingEvent var1);
    }
}

