/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.HandlingEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class HandlingEventList {
    private final Optional<List<HandlingEvent>> handlingEvents;
    private final Map<String, Object> additionalProperties;

    private HandlingEventList(Optional<List<HandlingEvent>> handlingEvents, Map<String, Object> additionalProperties) {
        this.handlingEvents = handlingEvents;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="handling_events")
    public Optional<List<HandlingEvent>> getHandlingEvents() {
        return this.handlingEvents;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof HandlingEventList && this.equalTo((HandlingEventList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HandlingEventList other) {
        return this.handlingEvents.equals(other.handlingEvents);
    }

    public int hashCode() {
        return Objects.hash(this.handlingEvents);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<HandlingEvent>> handlingEvents = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(HandlingEventList other) {
            this.handlingEvents(other.getHandlingEvents());
            return this;
        }

        @JsonSetter(value="handling_events", nulls=Nulls.SKIP)
        public Builder handlingEvents(Optional<List<HandlingEvent>> handlingEvents) {
            this.handlingEvents = handlingEvents;
            return this;
        }

        public Builder handlingEvents(List<HandlingEvent> handlingEvents) {
            this.handlingEvents = Optional.ofNullable(handlingEvents);
            return this;
        }

        public HandlingEventList build() {
            return new HandlingEventList(this.handlingEvents, this.additionalProperties);
        }
    }
}

