/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.SingleFilterSearchRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MultipleFilterSearchRequest {
    private final Optional<Operator> operator;
    private final Optional<Value> value;
    private final Map<String, Object> additionalProperties;

    private MultipleFilterSearchRequest(Optional<Operator> operator, Optional<Value> value, Map<String, Object> additionalProperties) {
        this.operator = operator;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="operator")
    public Optional<Operator> getOperator() {
        return this.operator;
    }

    @JsonProperty(value="value")
    public Optional<Value> getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MultipleFilterSearchRequest && this.equalTo((MultipleFilterSearchRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MultipleFilterSearchRequest other) {
        return this.operator.equals(other.operator) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Operator {
        public static final Operator AND = new Operator(Value.AND, "AND");
        public static final Operator OR = new Operator(Value.OR, "OR");
        private final Value value;
        private final String string;

        Operator(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Operator && this.string.equals(((Operator)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case AND: {
                    return visitor.visitAnd();
                }
                case OR: {
                    return visitor.visitOr();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Operator valueOf(String value) {
            switch (value) {
                case "AND": {
                    return AND;
                }
                case "OR": {
                    return OR;
                }
            }
            return new Operator(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitAnd();

            public T visitOr();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            AND,
            OR,
            UNKNOWN;

        }
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class Value {
        private final Object value;
        private final int type;

        private Value(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visitListOfMultipleFilterSearchRequest((List)this.value);
            }
            if (this.type == 1) {
                return visitor.visitListOfSingleFilterSearchRequest((List)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Value && this.equalTo((Value)other);
        }

        private boolean equalTo(Value other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static Value ofListOfMultipleFilterSearchRequest(List<MultipleFilterSearchRequest> value) {
            return new Value(value, 0);
        }

        public static Value ofListOfSingleFilterSearchRequest(List<SingleFilterSearchRequest> value) {
            return new Value(value, 1);
        }

        static final class Deserializer
        extends StdDeserializer<Value> {
            Deserializer() {
                super(Value.class);
            }

            public Value deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return Value.ofListOfMultipleFilterSearchRequest((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<MultipleFilterSearchRequest>>(){}));
                }
                catch (RuntimeException runtimeException) {
                    try {
                        return Value.ofListOfSingleFilterSearchRequest((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<SingleFilterSearchRequest>>(){}));
                    }
                    catch (RuntimeException runtimeException2) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visitListOfMultipleFilterSearchRequest(List<MultipleFilterSearchRequest> var1);

            public T visitListOfSingleFilterSearchRequest(List<SingleFilterSearchRequest> var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Operator> operator = Optional.empty();
        private Optional<Value> value = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(MultipleFilterSearchRequest other) {
            this.operator(other.getOperator());
            this.value(other.getValue());
            return this;
        }

        @JsonSetter(value="operator", nulls=Nulls.SKIP)
        public Builder operator(Optional<Operator> operator) {
            this.operator = operator;
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = Optional.ofNullable(operator);
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<Value> value) {
            this.value = value;
            return this;
        }

        public Builder value(Value value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public MultipleFilterSearchRequest build() {
            return new MultipleFilterSearchRequest(this.operator, this.value, this.additionalProperties);
        }
    }
}

