/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.news.types.NewsfeedAssignment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class NewsItemRequest {
    private final String title;
    private final Optional<String> body;
    private final int senderId;
    private final Optional<State> state;
    private final Optional<Boolean> deliverSilently;
    private final Optional<List<String>> labels;
    private final Optional<List<Optional<String>>> reactions;
    private final Optional<List<NewsfeedAssignment>> newsfeedAssignments;
    private final Map<String, Object> additionalProperties;

    private NewsItemRequest(String title, Optional<String> body, int senderId, Optional<State> state, Optional<Boolean> deliverSilently, Optional<List<String>> labels, Optional<List<Optional<String>>> reactions, Optional<List<NewsfeedAssignment>> newsfeedAssignments, Map<String, Object> additionalProperties) {
        this.title = title;
        this.body = body;
        this.senderId = senderId;
        this.state = state;
        this.deliverSilently = deliverSilently;
        this.labels = labels;
        this.reactions = reactions;
        this.newsfeedAssignments = newsfeedAssignments;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="sender_id")
    public int getSenderId() {
        return this.senderId;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @JsonProperty(value="deliver_silently")
    public Optional<Boolean> getDeliverSilently() {
        return this.deliverSilently;
    }

    @JsonProperty(value="labels")
    public Optional<List<String>> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="reactions")
    public Optional<List<Optional<String>>> getReactions() {
        return this.reactions;
    }

    @JsonProperty(value="newsfeed_assignments")
    public Optional<List<NewsfeedAssignment>> getNewsfeedAssignments() {
        return this.newsfeedAssignments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NewsItemRequest && this.equalTo((NewsItemRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NewsItemRequest other) {
        return this.title.equals(other.title) && this.body.equals(other.body) && this.senderId == other.senderId && this.state.equals(other.state) && this.deliverSilently.equals(other.deliverSilently) && this.labels.equals(other.labels) && this.reactions.equals(other.reactions) && this.newsfeedAssignments.equals(other.newsfeedAssignments);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.senderId, this.state, this.deliverSilently, this.labels, this.reactions, this.newsfeedAssignments);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case LIVE: {
                    return visitor.visitLive();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live": {
                    return LIVE;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitDraft();

            public T visitLive();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            DRAFT,
            LIVE,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    SenderIdStage,
    _FinalStage {
        private String title;
        private int senderId;
        private Optional<List<NewsfeedAssignment>> newsfeedAssignments = Optional.empty();
        private Optional<List<Optional<String>>> reactions = Optional.empty();
        private Optional<List<String>> labels = Optional.empty();
        private Optional<Boolean> deliverSilently = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(NewsItemRequest other) {
            this.title(other.getTitle());
            this.body(other.getBody());
            this.senderId(other.getSenderId());
            this.state(other.getState());
            this.deliverSilently(other.getDeliverSilently());
            this.labels(other.getLabels());
            this.reactions(other.getReactions());
            this.newsfeedAssignments(other.getNewsfeedAssignments());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public SenderIdStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="sender_id")
        public _FinalStage senderId(int senderId) {
            this.senderId = senderId;
            return this;
        }

        @Override
        public _FinalStage newsfeedAssignments(List<NewsfeedAssignment> newsfeedAssignments) {
            this.newsfeedAssignments = Optional.ofNullable(newsfeedAssignments);
            return this;
        }

        @Override
        @JsonSetter(value="newsfeed_assignments", nulls=Nulls.SKIP)
        public _FinalStage newsfeedAssignments(Optional<List<NewsfeedAssignment>> newsfeedAssignments) {
            this.newsfeedAssignments = newsfeedAssignments;
            return this;
        }

        @Override
        public _FinalStage reactions(List<Optional<String>> reactions) {
            this.reactions = Optional.ofNullable(reactions);
            return this;
        }

        @Override
        @JsonSetter(value="reactions", nulls=Nulls.SKIP)
        public _FinalStage reactions(Optional<List<Optional<String>>> reactions) {
            this.reactions = reactions;
            return this;
        }

        @Override
        public _FinalStage labels(List<String> labels) {
            this.labels = Optional.ofNullable(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(Optional<List<String>> labels) {
            this.labels = labels;
            return this;
        }

        @Override
        public _FinalStage deliverSilently(Boolean deliverSilently) {
            this.deliverSilently = Optional.ofNullable(deliverSilently);
            return this;
        }

        @Override
        @JsonSetter(value="deliver_silently", nulls=Nulls.SKIP)
        public _FinalStage deliverSilently(Optional<Boolean> deliverSilently) {
            this.deliverSilently = deliverSilently;
            return this;
        }

        @Override
        public _FinalStage state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @Override
        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public _FinalStage state(Optional<State> state) {
            this.state = state;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public NewsItemRequest build() {
            return new NewsItemRequest(this.title, this.body, this.senderId, this.state, this.deliverSilently, this.labels, this.reactions, this.newsfeedAssignments, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public NewsItemRequest build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage state(Optional<State> var1);

        public _FinalStage state(State var1);

        public _FinalStage deliverSilently(Optional<Boolean> var1);

        public _FinalStage deliverSilently(Boolean var1);

        public _FinalStage labels(Optional<List<String>> var1);

        public _FinalStage labels(List<String> var1);

        public _FinalStage reactions(Optional<List<Optional<String>>> var1);

        public _FinalStage reactions(List<Optional<String>> var1);

        public _FinalStage newsfeedAssignments(Optional<List<NewsfeedAssignment>> var1);

        public _FinalStage newsfeedAssignments(List<NewsfeedAssignment> var1);
    }

    public static interface SenderIdStage {
        public _FinalStage senderId(int var1);
    }

    public static interface TitleStage {
        public SenderIdStage title(@NotNull String var1);

        public Builder from(NewsItemRequest var1);
    }
}

