/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TeammateReference {
    private final Type type;
    private final int id;
    private final String name;
    private final Optional<String> email;
    private final Map<String, Object> additionalProperties;

    private TeammateReference(Type type, int id, String name, Optional<String> email, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TeammateReference && this.equalTo((TeammateReference)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeammateReference other) {
        return this.type.equals(other.type) && this.id == other.id && this.name.equals(other.name) && this.email.equals(other.email);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.email);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public static final class Type {
        public static final Type BOT = new Type(Value.BOT, "bot");
        public static final Type ADMIN = new Type(Value.ADMIN, "admin");
        public static final Type TEAM = new Type(Value.TEAM, "team");
        private final Value value;
        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Type && this.string.equals(((Type)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case BOT: {
                    return visitor.visitBot();
                }
                case ADMIN: {
                    return visitor.visitAdmin();
                }
                case TEAM: {
                    return visitor.visitTeam();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "bot": {
                    return BOT;
                }
                case "admin": {
                    return ADMIN;
                }
                case "team": {
                    return TEAM;
                }
            }
            return new Type(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitAdmin();

            public T visitTeam();

            public T visitBot();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ADMIN,
            TEAM,
            BOT,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    IdStage,
    NameStage,
    _FinalStage {
        private Type type;
        private int id;
        private String name;
        private Optional<String> email = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TeammateReference other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.email(other.getEmail());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public IdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(int id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @Override
        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @Override
        public TeammateReference build() {
            return new TeammateReference(this.type, this.id, this.name, this.email, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TeammateReference build();

        public _FinalStage email(Optional<String> var1);

        public _FinalStage email(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(int var1);
    }

    public static interface TypeStage {
        public IdStage type(@NotNull Type var1);

        public Builder from(TeammateReference var1);
    }
}

