/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.PartAttachment;
import com.intercom.api.resources.unstable.types.TicketPartAuthor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketReply {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<PartType> partType;
    private final Optional<String> body;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<TicketPartAuthor> author;
    private final Optional<List<PartAttachment>> attachments;
    private final Optional<Boolean> redacted;
    private final Map<String, Object> additionalProperties;

    private TicketReply(Optional<String> type, Optional<String> id, Optional<PartType> partType, Optional<String> body, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<TicketPartAuthor> author, Optional<List<PartAttachment>> attachments, Optional<Boolean> redacted, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.author = author;
        this.attachments = attachments;
        this.redacted = redacted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="part_type")
    public Optional<PartType> getPartType() {
        return this.partType;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="author")
    public Optional<TicketPartAuthor> getAuthor() {
        return this.author;
    }

    @JsonProperty(value="attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="redacted")
    public Optional<Boolean> getRedacted() {
        return this.redacted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketReply && this.equalTo((TicketReply)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketReply other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.partType.equals(other.partType) && this.body.equals(other.body) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.author.equals(other.author) && this.attachments.equals(other.attachments) && this.redacted.equals(other.redacted);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.author, this.attachments, this.redacted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class PartType {
        public static final PartType NOTE = new PartType(Value.NOTE, "note");
        public static final PartType QUICK_REPLY = new PartType(Value.QUICK_REPLY, "quick_reply");
        public static final PartType COMMENT = new PartType(Value.COMMENT, "comment");
        private final Value value;
        private final String string;

        PartType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof PartType && this.string.equals(((PartType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case NOTE: {
                    return visitor.visitNote();
                }
                case QUICK_REPLY: {
                    return visitor.visitQuickReply();
                }
                case COMMENT: {
                    return visitor.visitComment();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static PartType valueOf(String value) {
            switch (value) {
                case "note": {
                    return NOTE;
                }
                case "quick_reply": {
                    return QUICK_REPLY;
                }
                case "comment": {
                    return COMMENT;
                }
            }
            return new PartType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitNote();

            public T visitComment();

            public T visitQuickReply();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            NOTE,
            COMMENT,
            QUICK_REPLY,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<PartType> partType = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<TicketPartAuthor> author = Optional.empty();
        private Optional<List<PartAttachment>> attachments = Optional.empty();
        private Optional<Boolean> redacted = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TicketReply other) {
            this.type(other.getType());
            this.id(other.getId());
            this.partType(other.getPartType());
            this.body(other.getBody());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.author(other.getAuthor());
            this.attachments(other.getAttachments());
            this.redacted(other.getRedacted());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="part_type", nulls=Nulls.SKIP)
        public Builder partType(Optional<PartType> partType) {
            this.partType = partType;
            return this;
        }

        public Builder partType(PartType partType) {
            this.partType = Optional.ofNullable(partType);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="author", nulls=Nulls.SKIP)
        public Builder author(Optional<TicketPartAuthor> author) {
            this.author = author;
            return this;
        }

        public Builder author(TicketPartAuthor author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public Builder attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        @JsonSetter(value="redacted", nulls=Nulls.SKIP)
        public Builder redacted(Optional<Boolean> redacted) {
            this.redacted = redacted;
            return this;
        }

        public Builder redacted(Boolean redacted) {
            this.redacted = Optional.ofNullable(redacted);
            return this;
        }

        public TicketReply build() {
            return new TicketReply(this.type, this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.author, this.attachments, this.redacted, this.additionalProperties);
        }
    }
}

