/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AssignConversationRequest {
    private final Type type;
    private final String adminId;
    private final String assigneeId;
    private final Optional<String> body;
    private final Map<String, Object> additionalProperties;

    private AssignConversationRequest(Type type, String adminId, String assigneeId, Optional<String> body, Map<String, Object> additionalProperties) {
        this.type = type;
        this.adminId = adminId;
        this.assigneeId = assigneeId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    @JsonProperty(value="assignee_id")
    public String getAssigneeId() {
        return this.assigneeId;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AssignConversationRequest && this.equalTo((AssignConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AssignConversationRequest other) {
        return this.type.equals(other.type) && this.adminId.equals(other.adminId) && this.assigneeId.equals(other.assigneeId) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.adminId, this.assigneeId, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public static final class Type {
        public static final Type ADMIN = new Type(Value.ADMIN, "admin");
        public static final Type TEAM = new Type(Value.TEAM, "team");
        private final Value value;
        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Type && this.string.equals(((Type)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case ADMIN: {
                    return visitor.visitAdmin();
                }
                case TEAM: {
                    return visitor.visitTeam();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "admin": {
                    return ADMIN;
                }
                case "team": {
                    return TEAM;
                }
            }
            return new Type(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitAdmin();

            public T visitTeam();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ADMIN,
            TEAM,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    AdminIdStage,
    AssigneeIdStage,
    _FinalStage {
        private Type type;
        private String adminId;
        private String assigneeId;
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AssignConversationRequest other) {
            this.type(other.getType());
            this.adminId(other.getAdminId());
            this.assigneeId(other.getAssigneeId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public AdminIdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public AssigneeIdStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="assignee_id")
        public _FinalStage assigneeId(@NotNull String assigneeId) {
            this.assigneeId = Objects.requireNonNull(assigneeId, "assigneeId must not be null");
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public AssignConversationRequest build() {
            return new AssignConversationRequest(this.type, this.adminId, this.assigneeId, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AssignConversationRequest build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);
    }

    public static interface AssigneeIdStage {
        public _FinalStage assigneeId(@NotNull String var1);
    }

    public static interface AdminIdStage {
        public AssigneeIdStage adminId(@NotNull String var1);
    }

    public static interface TypeStage {
        public AdminIdStage type(@NotNull Type var1);

        public Builder from(AssignConversationRequest var1);
    }
}

