/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationAttachmentFiles {
    private final Optional<String> contentType;
    private final Optional<String> data;
    private final Optional<String> name;
    private final Map<String, Object> additionalProperties;

    private ConversationAttachmentFiles(Optional<String> contentType, Optional<String> data, Optional<String> name, Map<String, Object> additionalProperties) {
        this.contentType = contentType;
        this.data = data;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="content_type")
    public Optional<String> getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="data")
    public Optional<String> getData() {
        return this.data;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationAttachmentFiles && this.equalTo((ConversationAttachmentFiles)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationAttachmentFiles other) {
        return this.contentType.equals(other.contentType) && this.data.equals(other.data) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.data, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> contentType = Optional.empty();
        private Optional<String> data = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationAttachmentFiles other) {
            this.contentType(other.getContentType());
            this.data(other.getData());
            this.name(other.getName());
            return this;
        }

        @JsonSetter(value="content_type", nulls=Nulls.SKIP)
        public Builder contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<String> data) {
            this.data = data;
            return this;
        }

        public Builder data(String data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public ConversationAttachmentFiles build() {
            return new ConversationAttachmentFiles(this.contentType, this.data, this.name, this.additionalProperties);
        }
    }
}

