/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=Deserializer.class)
public final class CreateDataAttributeRequest {
    private final Object value;
    private final int type;

    private CreateDataAttributeRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((Options)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((One)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDataAttributeRequest && this.equalTo((CreateDataAttributeRequest)other);
    }

    private boolean equalTo(CreateDataAttributeRequest other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static CreateDataAttributeRequest of(Options value) {
        return new CreateDataAttributeRequest(value, 0);
    }

    public static CreateDataAttributeRequest of(One value) {
        return new CreateDataAttributeRequest(value, 1);
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class One {
        private final Optional<DataType> dataType;
        private final Map<String, Object> additionalProperties;

        private One(Optional<DataType> dataType, Map<String, Object> additionalProperties) {
            this.dataType = dataType;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="data_type")
        public Optional<DataType> getDataType() {
            return this.dataType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof One && this.equalTo((One)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(One other) {
            return this.dataType.equals(other.dataType);
        }

        public int hashCode() {
            return Objects.hash(this.dataType);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class DataType {
            public static final DataType STRING = new DataType(Value.STRING, "string");
            public static final DataType FLOAT = new DataType(Value.FLOAT, "float");
            public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");
            public static final DataType DATETIME = new DataType(Value.DATETIME, "datetime");
            public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");
            public static final DataType DATE = new DataType(Value.DATE, "date");
            private final Value value;
            private final String string;

            DataType(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return this.value;
            }

            @JsonValue
            public String toString() {
                return this.string;
            }

            public boolean equals(Object other) {
                return this == other || other instanceof DataType && this.string.equals(((DataType)other).string);
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (this.value) {
                    case STRING: {
                        return visitor.visitString();
                    }
                    case FLOAT: {
                        return visitor.visitFloat();
                    }
                    case INTEGER: {
                        return visitor.visitInteger();
                    }
                    case DATETIME: {
                        return visitor.visitDatetime();
                    }
                    case BOOLEAN: {
                        return visitor.visitBoolean();
                    }
                    case DATE: {
                        return visitor.visitDate();
                    }
                }
                return visitor.visitUnknown(this.string);
            }

            @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
            public static DataType valueOf(String value) {
                switch (value) {
                    case "string": {
                        return STRING;
                    }
                    case "float": {
                        return FLOAT;
                    }
                    case "integer": {
                        return INTEGER;
                    }
                    case "datetime": {
                        return DATETIME;
                    }
                    case "boolean": {
                        return BOOLEAN;
                    }
                    case "date": {
                        return DATE;
                    }
                }
                return new DataType(Value.UNKNOWN, value);
            }

            public static interface Visitor<T> {
                public T visitString();

                public T visitInteger();

                public T visitFloat();

                public T visitBoolean();

                public T visitDatetime();

                public T visitDate();

                public T visitUnknown(String var1);
            }

            public static enum Value {
                STRING,
                INTEGER,
                FLOAT,
                BOOLEAN,
                DATETIME,
                DATE,
                UNKNOWN;

            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<DataType> dataType = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(One other) {
                this.dataType(other.getDataType());
                return this;
            }

            @JsonSetter(value="data_type", nulls=Nulls.SKIP)
            public Builder dataType(Optional<DataType> dataType) {
                this.dataType = dataType;
                return this;
            }

            public Builder dataType(DataType dataType) {
                this.dataType = Optional.ofNullable(dataType);
                return this;
            }

            public One build() {
                return new One(this.dataType, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Options {
        private final Optional<String> dataType;
        private final List<OptionsItem> options;
        private final Map<String, Object> additionalProperties;

        private Options(Optional<String> dataType, List<OptionsItem> options, Map<String, Object> additionalProperties) {
            this.dataType = dataType;
            this.options = options;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="data_type")
        public Optional<String> getDataType() {
            return this.dataType;
        }

        @JsonProperty(value="options")
        public List<OptionsItem> getOptions() {
            return this.options;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Options && this.equalTo((Options)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Options other) {
            return this.dataType.equals(other.dataType) && this.options.equals(other.options);
        }

        public int hashCode() {
            return Objects.hash(this.dataType, this.options);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class OptionsItem {
            private final Optional<String> value;
            private final Map<String, Object> additionalProperties;

            private OptionsItem(Optional<String> value, Map<String, Object> additionalProperties) {
                this.value = value;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="value")
            public Optional<String> getValue() {
                return this.value;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof OptionsItem && this.equalTo((OptionsItem)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(OptionsItem other) {
                return this.value.equals(other.value);
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder {
                private Optional<String> value = Optional.empty();
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                public Builder from(OptionsItem other) {
                    this.value(other.getValue());
                    return this;
                }

                @JsonSetter(value="value", nulls=Nulls.SKIP)
                public Builder value(Optional<String> value) {
                    this.value = value;
                    return this;
                }

                public Builder value(String value) {
                    this.value = Optional.ofNullable(value);
                    return this;
                }

                public OptionsItem build() {
                    return new OptionsItem(this.value, this.additionalProperties);
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> dataType = Optional.empty();
            private List<OptionsItem> options = new ArrayList<OptionsItem>();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Options other) {
                this.dataType(other.getDataType());
                this.options(other.getOptions());
                return this;
            }

            @JsonSetter(value="data_type", nulls=Nulls.SKIP)
            public Builder dataType(Optional<String> dataType) {
                this.dataType = dataType;
                return this;
            }

            public Builder dataType(String dataType) {
                this.dataType = Optional.ofNullable(dataType);
                return this;
            }

            @JsonSetter(value="options", nulls=Nulls.SKIP)
            public Builder options(List<OptionsItem> options) {
                this.options.clear();
                if (options != null) {
                    this.options.addAll(options);
                }
                return this;
            }

            public Builder addOptions(OptionsItem options) {
                this.options.add(options);
                return this;
            }

            public Builder addAllOptions(List<OptionsItem> options) {
                if (options != null) {
                    this.options.addAll(options);
                }
                return this;
            }

            public Options build() {
                return new Options(this.dataType, this.options, this.additionalProperties);
            }
        }
    }

    static final class Deserializer
    extends StdDeserializer<CreateDataAttributeRequest> {
        Deserializer() {
            super(CreateDataAttributeRequest.class);
        }

        public CreateDataAttributeRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return CreateDataAttributeRequest.of((Options)ObjectMappers.JSON_MAPPER.convertValue(value, Options.class));
            }
            catch (RuntimeException runtimeException) {
                try {
                    return CreateDataAttributeRequest.of((One)ObjectMappers.JSON_MAPPER.convertValue(value, One.class));
                }
                catch (RuntimeException runtimeException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(Options var1);

        public T visit(One var1);
    }
}

