/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class CreateMessageRequest {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private CreateMessageRequest(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static CreateMessageRequest email(Email value) {
        return new CreateMessageRequest(new EmailValue(value));
    }

    public static CreateMessageRequest inapp(Inapp value) {
        return new CreateMessageRequest(new InappValue(value));
    }

    public boolean isEmail() {
        return this.value instanceof EmailValue;
    }

    public boolean isInapp() {
        return this.value instanceof InappValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<Email> getEmail() {
        if (this.isEmail()) {
            return Optional.of(((EmailValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Inapp> getInapp() {
        if (this.isInapp()) {
            return Optional.of(((InappValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Inapp {
        private final Optional<String> subject;
        private final String body;
        private final Optional<String> template;
        private final From from;
        private final To to;
        private final Optional<Integer> createdAt;
        private final Optional<Boolean> createConversationWithoutContactReply;
        private final Map<String, Object> additionalProperties;

        private Inapp(Optional<String> subject, String body, Optional<String> template, From from, To to, Optional<Integer> createdAt, Optional<Boolean> createConversationWithoutContactReply, Map<String, Object> additionalProperties) {
            this.subject = subject;
            this.body = body;
            this.template = template;
            this.from = from;
            this.to = to;
            this.createdAt = createdAt;
            this.createConversationWithoutContactReply = createConversationWithoutContactReply;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="subject")
        public Optional<String> getSubject() {
            return this.subject;
        }

        @JsonProperty(value="body")
        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="template")
        public Optional<String> getTemplate() {
            return this.template;
        }

        @JsonProperty(value="from")
        public From getFrom() {
            return this.from;
        }

        @JsonProperty(value="to")
        public To getTo() {
            return this.to;
        }

        @JsonProperty(value="created_at")
        public Optional<Integer> getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="create_conversation_without_contact_reply")
        public Optional<Boolean> getCreateConversationWithoutContactReply() {
            return this.createConversationWithoutContactReply;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Inapp && this.equalTo((Inapp)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Inapp other) {
            return this.subject.equals(other.subject) && this.body.equals(other.body) && this.template.equals(other.template) && this.from.equals(other.from) && this.to.equals(other.to) && this.createdAt.equals(other.createdAt) && this.createConversationWithoutContactReply.equals(other.createConversationWithoutContactReply);
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.body, this.template, this.from, this.to, this.createdAt, this.createConversationWithoutContactReply);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static BodyStage builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class To {
            private final Type type;
            private final String id;
            private final Map<String, Object> additionalProperties;

            private To(Type type, String id, Map<String, Object> additionalProperties) {
                this.type = type;
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="type")
            public Type getType() {
                return this.type;
            }

            @JsonProperty(value="id")
            public String getId() {
                return this.id;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof To && this.equalTo((To)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(To other) {
                return this.type.equals(other.type) && this.id.equals(other.id);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.id);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static TypeStage builder() {
                return new Builder();
            }

            public static final class Type {
                public static final Type USER = new Type(Value.USER, "user");
                public static final Type LEAD = new Type(Value.LEAD, "lead");
                private final Value value;
                private final String string;

                Type(Value value, String string) {
                    this.value = value;
                    this.string = string;
                }

                public Value getEnumValue() {
                    return this.value;
                }

                @JsonValue
                public String toString() {
                    return this.string;
                }

                public boolean equals(Object other) {
                    return this == other || other instanceof Type && this.string.equals(((Type)other).string);
                }

                public int hashCode() {
                    return this.string.hashCode();
                }

                public <T> T visit(Visitor<T> visitor) {
                    switch (this.value) {
                        case USER: {
                            return visitor.visitUser();
                        }
                        case LEAD: {
                            return visitor.visitLead();
                        }
                    }
                    return visitor.visitUnknown(this.string);
                }

                @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
                public static Type valueOf(String value) {
                    switch (value) {
                        case "user": {
                            return USER;
                        }
                        case "lead": {
                            return LEAD;
                        }
                    }
                    return new Type(Value.UNKNOWN, value);
                }

                public static interface Visitor<T> {
                    public T visitUser();

                    public T visitLead();

                    public T visitUnknown(String var1);
                }

                public static enum Value {
                    USER,
                    LEAD,
                    UNKNOWN;

                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements TypeStage,
            IdStage,
            _FinalStage {
                private Type type;
                private String id;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(To other) {
                    this.type(other.getType());
                    this.id(other.getId());
                    return this;
                }

                @Override
                @JsonSetter(value="type")
                public IdStage type(@NotNull Type type) {
                    this.type = Objects.requireNonNull(type, "type must not be null");
                    return this;
                }

                @Override
                @JsonSetter(value="id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @Override
                public To build() {
                    return new To(this.type, this.id, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public To build();
            }

            public static interface IdStage {
                public _FinalStage id(@NotNull String var1);
            }

            public static interface TypeStage {
                public IdStage type(@NotNull Type var1);

                public Builder from(To var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class From {
            private final int id;
            private final Map<String, Object> additionalProperties;

            private From(int id, Map<String, Object> additionalProperties) {
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="type")
            public String getType() {
                return "admin";
            }

            @JsonProperty(value="id")
            public int getId() {
                return this.id;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof From && this.equalTo((From)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(From other) {
                return this.id == other.id;
            }

            public int hashCode() {
                return Objects.hash(this.id);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements IdStage,
            _FinalStage {
                private int id;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(From other) {
                    this.id(other.getId());
                    return this;
                }

                @Override
                @JsonSetter(value="id")
                public _FinalStage id(int id) {
                    this.id = id;
                    return this;
                }

                @Override
                public From build() {
                    return new From(this.id, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public From build();
            }

            public static interface IdStage {
                public _FinalStage id(int var1);

                public Builder from(From var1);
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements BodyStage,
        FromStage,
        ToStage,
        _FinalStage {
            private String body;
            private From from;
            private To to;
            private Optional<Boolean> createConversationWithoutContactReply = Optional.empty();
            private Optional<Integer> createdAt = Optional.empty();
            private Optional<String> template = Optional.empty();
            private Optional<String> subject = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(Inapp other) {
                this.subject(other.getSubject());
                this.body(other.getBody());
                this.template(other.getTemplate());
                this.from(other.getFrom());
                this.to(other.getTo());
                this.createdAt(other.getCreatedAt());
                this.createConversationWithoutContactReply(other.getCreateConversationWithoutContactReply());
                return this;
            }

            @Override
            @JsonSetter(value="body")
            public FromStage body(@NotNull String body) {
                this.body = Objects.requireNonNull(body, "body must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="from")
            public ToStage from(@NotNull From from) {
                this.from = Objects.requireNonNull(from, "from must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="to")
            public _FinalStage to(@NotNull To to) {
                this.to = Objects.requireNonNull(to, "to must not be null");
                return this;
            }

            @Override
            public _FinalStage createConversationWithoutContactReply(Boolean createConversationWithoutContactReply) {
                this.createConversationWithoutContactReply = Optional.ofNullable(createConversationWithoutContactReply);
                return this;
            }

            @Override
            @JsonSetter(value="create_conversation_without_contact_reply", nulls=Nulls.SKIP)
            public _FinalStage createConversationWithoutContactReply(Optional<Boolean> createConversationWithoutContactReply) {
                this.createConversationWithoutContactReply = createConversationWithoutContactReply;
                return this;
            }

            @Override
            public _FinalStage createdAt(Integer createdAt) {
                this.createdAt = Optional.ofNullable(createdAt);
                return this;
            }

            @Override
            @JsonSetter(value="created_at", nulls=Nulls.SKIP)
            public _FinalStage createdAt(Optional<Integer> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @Override
            public _FinalStage template(String template) {
                this.template = Optional.ofNullable(template);
                return this;
            }

            @Override
            @JsonSetter(value="template", nulls=Nulls.SKIP)
            public _FinalStage template(Optional<String> template) {
                this.template = template;
                return this;
            }

            @Override
            public _FinalStage subject(String subject) {
                this.subject = Optional.ofNullable(subject);
                return this;
            }

            @Override
            @JsonSetter(value="subject", nulls=Nulls.SKIP)
            public _FinalStage subject(Optional<String> subject) {
                this.subject = subject;
                return this;
            }

            @Override
            public Inapp build() {
                return new Inapp(this.subject, this.body, this.template, this.from, this.to, this.createdAt, this.createConversationWithoutContactReply, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public Inapp build();

            public _FinalStage subject(Optional<String> var1);

            public _FinalStage subject(String var1);

            public _FinalStage template(Optional<String> var1);

            public _FinalStage template(String var1);

            public _FinalStage createdAt(Optional<Integer> var1);

            public _FinalStage createdAt(Integer var1);

            public _FinalStage createConversationWithoutContactReply(Optional<Boolean> var1);

            public _FinalStage createConversationWithoutContactReply(Boolean var1);
        }

        public static interface ToStage {
            public _FinalStage to(@NotNull To var1);
        }

        public static interface FromStage {
            public ToStage from(@NotNull From var1);
        }

        public static interface BodyStage {
            public FromStage body(@NotNull String var1);

            public Builder from(Inapp var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Email {
        private final String subject;
        private final String body;
        private final String template;
        private final From from;
        private final To to;
        private final Optional<Integer> createdAt;
        private final Optional<Boolean> createConversationWithoutContactReply;
        private final Map<String, Object> additionalProperties;

        private Email(String subject, String body, String template, From from, To to, Optional<Integer> createdAt, Optional<Boolean> createConversationWithoutContactReply, Map<String, Object> additionalProperties) {
            this.subject = subject;
            this.body = body;
            this.template = template;
            this.from = from;
            this.to = to;
            this.createdAt = createdAt;
            this.createConversationWithoutContactReply = createConversationWithoutContactReply;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="subject")
        public String getSubject() {
            return this.subject;
        }

        @JsonProperty(value="body")
        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="template")
        public String getTemplate() {
            return this.template;
        }

        @JsonProperty(value="from")
        public From getFrom() {
            return this.from;
        }

        @JsonProperty(value="to")
        public To getTo() {
            return this.to;
        }

        @JsonProperty(value="created_at")
        public Optional<Integer> getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="create_conversation_without_contact_reply")
        public Optional<Boolean> getCreateConversationWithoutContactReply() {
            return this.createConversationWithoutContactReply;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Email && this.equalTo((Email)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Email other) {
            return this.subject.equals(other.subject) && this.body.equals(other.body) && this.template.equals(other.template) && this.from.equals(other.from) && this.to.equals(other.to) && this.createdAt.equals(other.createdAt) && this.createConversationWithoutContactReply.equals(other.createConversationWithoutContactReply);
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.body, this.template, this.from, this.to, this.createdAt, this.createConversationWithoutContactReply);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static SubjectStage builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class To {
            private final Type type;
            private final String id;
            private final Map<String, Object> additionalProperties;

            private To(Type type, String id, Map<String, Object> additionalProperties) {
                this.type = type;
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="type")
            public Type getType() {
                return this.type;
            }

            @JsonProperty(value="id")
            public String getId() {
                return this.id;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof To && this.equalTo((To)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(To other) {
                return this.type.equals(other.type) && this.id.equals(other.id);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.id);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static TypeStage builder() {
                return new Builder();
            }

            public static final class Type {
                public static final Type USER = new Type(Value.USER, "user");
                public static final Type LEAD = new Type(Value.LEAD, "lead");
                private final Value value;
                private final String string;

                Type(Value value, String string) {
                    this.value = value;
                    this.string = string;
                }

                public Value getEnumValue() {
                    return this.value;
                }

                @JsonValue
                public String toString() {
                    return this.string;
                }

                public boolean equals(Object other) {
                    return this == other || other instanceof Type && this.string.equals(((Type)other).string);
                }

                public int hashCode() {
                    return this.string.hashCode();
                }

                public <T> T visit(Visitor<T> visitor) {
                    switch (this.value) {
                        case USER: {
                            return visitor.visitUser();
                        }
                        case LEAD: {
                            return visitor.visitLead();
                        }
                    }
                    return visitor.visitUnknown(this.string);
                }

                @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
                public static Type valueOf(String value) {
                    switch (value) {
                        case "user": {
                            return USER;
                        }
                        case "lead": {
                            return LEAD;
                        }
                    }
                    return new Type(Value.UNKNOWN, value);
                }

                public static interface Visitor<T> {
                    public T visitUser();

                    public T visitLead();

                    public T visitUnknown(String var1);
                }

                public static enum Value {
                    USER,
                    LEAD,
                    UNKNOWN;

                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements TypeStage,
            IdStage,
            _FinalStage {
                private Type type;
                private String id;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(To other) {
                    this.type(other.getType());
                    this.id(other.getId());
                    return this;
                }

                @Override
                @JsonSetter(value="type")
                public IdStage type(@NotNull Type type) {
                    this.type = Objects.requireNonNull(type, "type must not be null");
                    return this;
                }

                @Override
                @JsonSetter(value="id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @Override
                public To build() {
                    return new To(this.type, this.id, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public To build();
            }

            public static interface IdStage {
                public _FinalStage id(@NotNull String var1);
            }

            public static interface TypeStage {
                public IdStage type(@NotNull Type var1);

                public Builder from(To var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class From {
            private final int id;
            private final Map<String, Object> additionalProperties;

            private From(int id, Map<String, Object> additionalProperties) {
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="type")
            public String getType() {
                return "admin";
            }

            @JsonProperty(value="id")
            public int getId() {
                return this.id;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof From && this.equalTo((From)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(From other) {
                return this.id == other.id;
            }

            public int hashCode() {
                return Objects.hash(this.id);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements IdStage,
            _FinalStage {
                private int id;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(From other) {
                    this.id(other.getId());
                    return this;
                }

                @Override
                @JsonSetter(value="id")
                public _FinalStage id(int id) {
                    this.id = id;
                    return this;
                }

                @Override
                public From build() {
                    return new From(this.id, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public From build();
            }

            public static interface IdStage {
                public _FinalStage id(int var1);

                public Builder from(From var1);
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements SubjectStage,
        BodyStage,
        TemplateStage,
        FromStage,
        ToStage,
        _FinalStage {
            private String subject;
            private String body;
            private String template;
            private From from;
            private To to;
            private Optional<Boolean> createConversationWithoutContactReply = Optional.empty();
            private Optional<Integer> createdAt = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(Email other) {
                this.subject(other.getSubject());
                this.body(other.getBody());
                this.template(other.getTemplate());
                this.from(other.getFrom());
                this.to(other.getTo());
                this.createdAt(other.getCreatedAt());
                this.createConversationWithoutContactReply(other.getCreateConversationWithoutContactReply());
                return this;
            }

            @Override
            @JsonSetter(value="subject")
            public BodyStage subject(@NotNull String subject) {
                this.subject = Objects.requireNonNull(subject, "subject must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="body")
            public TemplateStage body(@NotNull String body) {
                this.body = Objects.requireNonNull(body, "body must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="template")
            public FromStage template(@NotNull String template) {
                this.template = Objects.requireNonNull(template, "template must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="from")
            public ToStage from(@NotNull From from) {
                this.from = Objects.requireNonNull(from, "from must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="to")
            public _FinalStage to(@NotNull To to) {
                this.to = Objects.requireNonNull(to, "to must not be null");
                return this;
            }

            @Override
            public _FinalStage createConversationWithoutContactReply(Boolean createConversationWithoutContactReply) {
                this.createConversationWithoutContactReply = Optional.ofNullable(createConversationWithoutContactReply);
                return this;
            }

            @Override
            @JsonSetter(value="create_conversation_without_contact_reply", nulls=Nulls.SKIP)
            public _FinalStage createConversationWithoutContactReply(Optional<Boolean> createConversationWithoutContactReply) {
                this.createConversationWithoutContactReply = createConversationWithoutContactReply;
                return this;
            }

            @Override
            public _FinalStage createdAt(Integer createdAt) {
                this.createdAt = Optional.ofNullable(createdAt);
                return this;
            }

            @Override
            @JsonSetter(value="created_at", nulls=Nulls.SKIP)
            public _FinalStage createdAt(Optional<Integer> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @Override
            public Email build() {
                return new Email(this.subject, this.body, this.template, this.from, this.to, this.createdAt, this.createConversationWithoutContactReply, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public Email build();

            public _FinalStage createdAt(Optional<Integer> var1);

            public _FinalStage createdAt(Integer var1);

            public _FinalStage createConversationWithoutContactReply(Optional<Boolean> var1);

            public _FinalStage createConversationWithoutContactReply(Boolean var1);
        }

        public static interface ToStage {
            public _FinalStage to(@NotNull To var1);
        }

        public static interface FromStage {
            public ToStage from(@NotNull From var1);
        }

        public static interface TemplateStage {
            public FromStage template(@NotNull String var1);
        }

        public static interface BodyStage {
            public TemplateStage body(@NotNull String var1);
        }

        public static interface SubjectStage {
            public BodyStage subject(@NotNull String var1);

            public Builder from(Email var1);
        }
    }

    @JsonIgnoreProperties(value={"message_type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "CreateMessageRequest{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="inapp")
    @JsonIgnoreProperties(value={"message_type"})
    private static final class InappValue
    implements Value {
        @JsonUnwrapped
        private Inapp value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private InappValue() {
        }

        private InappValue(Inapp value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitInapp(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof InappValue && this.equalTo((InappValue)other);
        }

        private boolean equalTo(InappValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CreateMessageRequest{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="email")
    @JsonIgnoreProperties(value={"message_type"})
    private static final class EmailValue
    implements Value {
        @JsonUnwrapped
        private Email value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private EmailValue() {
        }

        private EmailValue(Email value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitEmail(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof EmailValue && this.equalTo((EmailValue)other);
        }

        private boolean equalTo(EmailValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CreateMessageRequest{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="message_type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=EmailValue.class), @JsonSubTypes.Type(value=InappValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitEmail(Email var1);

        public T visitInapp(Inapp var1);

        public T _visitUnknown(Object var1);
    }
}

