/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomChannelContact {
    private final Type type;
    private final String externalId;
    private final Optional<String> name;
    private final Optional<String> email;
    private final Map<String, Object> additionalProperties;

    private CustomChannelContact(Type type, String externalId, Optional<String> name, Optional<String> email, Map<String, Object> additionalProperties) {
        this.type = type;
        this.externalId = externalId;
        this.name = name;
        this.email = email;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomChannelContact && this.equalTo((CustomChannelContact)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomChannelContact other) {
        return this.type.equals(other.type) && this.externalId.equals(other.externalId) && this.name.equals(other.name) && this.email.equals(other.email);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.externalId, this.name, this.email);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public static final class Type {
        public static final Type USER = new Type(Value.USER, "user");
        public static final Type LEAD = new Type(Value.LEAD, "lead");
        private final Value value;
        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Type && this.string.equals(((Type)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case USER: {
                    return visitor.visitUser();
                }
                case LEAD: {
                    return visitor.visitLead();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "user": {
                    return USER;
                }
                case "lead": {
                    return LEAD;
                }
            }
            return new Type(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitUser();

            public T visitLead();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            USER,
            LEAD,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    ExternalIdStage,
    _FinalStage {
        private Type type;
        private String externalId;
        private Optional<String> email = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CustomChannelContact other) {
            this.type(other.getType());
            this.externalId(other.getExternalId());
            this.name(other.getName());
            this.email(other.getEmail());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public ExternalIdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public _FinalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @Override
        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public CustomChannelContact build() {
            return new CustomChannelContact(this.type, this.externalId, this.name, this.email, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CustomChannelContact build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage email(Optional<String> var1);

        public _FinalStage email(String var1);
    }

    public static interface ExternalIdStage {
        public _FinalStage externalId(@NotNull String var1);
    }

    public static interface TypeStage {
        public ExternalIdStage type(@NotNull Type var1);

        public Builder from(CustomChannelContact var1);
    }
}

