/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.internalarticles.types.InternalArticleListItem;
import com.intercom.api.types.CursorPages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InternalArticleList {
    private final Optional<String> type;
    private final Optional<CursorPages> pages;
    private final Optional<Integer> totalCount;
    private final Optional<List<InternalArticleListItem>> data;
    private final Map<String, Object> additionalProperties;

    private InternalArticleList(Optional<String> type, Optional<CursorPages> pages, Optional<Integer> totalCount, Optional<List<InternalArticleListItem>> data, Map<String, Object> additionalProperties) {
        this.type = type;
        this.pages = pages;
        this.totalCount = totalCount;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    @JsonProperty(value="total_count")
    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="data")
    public Optional<List<InternalArticleListItem>> getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InternalArticleList && this.equalTo((InternalArticleList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InternalArticleList other) {
        return this.type.equals(other.type) && this.pages.equals(other.pages) && this.totalCount.equals(other.totalCount) && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pages, this.totalCount, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<CursorPages> pages = Optional.empty();
        private Optional<Integer> totalCount = Optional.empty();
        private Optional<List<InternalArticleListItem>> data = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InternalArticleList other) {
            this.type(other.getType());
            this.pages(other.getPages());
            this.totalCount(other.getTotalCount());
            this.data(other.getData());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<List<InternalArticleListItem>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<InternalArticleListItem> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public InternalArticleList build() {
            return new InternalArticleList(this.type, this.pages, this.totalCount, this.data, this.additionalProperties);
        }
    }
}

